**************************************************************************
*                                                                        *
*  CALENDAR.PRG                                                          *
*                                                                        *
*  Sample program which prints one month of a calendar using ESCAPE      *
*                                                                        *
**************************************************************************
#include "samples.ch"

FUNCTION CALENDAR()

  LOCAL nTitleWidth := .4                     // Width of the Title Bar
  LOCAL nTop        := 2.4                    // Starting position in inches
  LOCAL nLeft       := .75                    // Left edge of calendar in inches
  LOCAL nRows       := 6                      // Number of rows in the calendar
  LOCAL nCols       := 7                      // Number of columns in the calendar
  LOCAL nHeight     := 1.25                   // Height of each calendar box
  LOCAL nWidth      := 1                      // Width of each calendar box
  LOCAL nRight      := nLeft+(nCols*nWidth)   // Right edge of calendar in inches
  LOCAL nBottom     := nTop+(nRows*nHeight)   // Bottom row of calendar in inches
  LOCAL nRow                                  // Row counter
  LOCAL nCol                                  // Column counter
  LOCAL nDay                                  // Day counter
  LOCAL nMonth      := 0                      // Month of calendar to print
  LOCAL nYear       := 0                      // Year of calendar to print
  LOCAL nDow                                  // Day of week counter
  LOCAL nDays                                 // Number of days in the month
  LOCAL dFirstDay                             // First day of the month
  LOCAL dLastDay                              // Last day of the month
  LOCAL cOldColor

  LOCAL aDays       := { 'SUNDAY', 'MONDAY', 'TUESDAY', 'WEDNESDAY', ;
                         'THURSDAY', 'FRIDAY', 'SATURDAY' }

  SET CONFIRM ON
  SET SCOREBOARD OFF

  cOldColor := SETCOLOR('bg+/b')
  @ 3,0 CLEAR

  SETCOLOR('w+/bg')
  @ 0,0,2,79 BOX 'Ŀ '
  @ 1,2 SAY 'Escape ver 3.0 - Sample Calendar Printing Program'

  ****
  * Ask the user what month to print
  ****
  IF .NOT. GetInput(@nMonth, @nYear)
    RETURN NIL
  ENDIF

  ****
  * Calculate the first and last day of the month
  ****
  CalcDays(nMonth, nYear, @dFirstDay, @dLastDay, @nDow, @nDays)


  *************************************************************************
  * BEGIN PRINTING CALENDAR USING ESCAPE                                  *
  *************************************************************************
  SETCOLOR('w+/b')
  @ 3,0 CLEAR
  ShowBox('Downloading Fonts...')

  hpPrintOn()
  hpDownload("GAR30.POR", 1, "LPT1",, DOWNLOADCHARS)
  hpDownload("GAR12.POR", 2, "LPT1",, DOWNLOADCHARS)

  hpPrintOff()
  ShowBox('Printing Sample Calendar Page...')
  hpPrintOn()

  hpConfig("LETTER", "P", 1)
  hpSetFont("GAR30.POR", "SF")

  hpPhysical(.T.)

  ****
  * Print title
  ****
  hpICenter(UPPER(CMONTH(dFirstDay)) + ' ' + LTRIM(STR(nYear)), nTop-nTitleWidth-1, 4.25, "I")

  ****
  * Draw outer box
  ****
  hpBox(nTop, nLeft, nBottom, nRight, 1, "I")

  ****
  * Draw gray title bar
  ****
  hpGrayBox(nTop-nTitleWidth, nLeft, nTop, nRight, 1, 10, "I")

  ****
  * Print days of week
  ****
  hpSetFont("GAR12.POR", "SF")
  FOR nDay = 0 to 6
    hpCenter(aDays[nDay+1], nTop-nTitleWidth/2, nLeft+(nWidth*nDay)+(nWidth/2), "I")
  NEXT

  ****
  * Draw vertical lines
  ****
  FOR nCol = 1 TO nCols
    hpBox(nTop, nLeft+(nWidth*nCol), nBottom, nLeft+(nWidth*nCol), 1, "I")
  NEXT

  ****
  * Draw horizontal lines
  ****
  FOR nRow = 1 TO nRows
    hpBox(nTop+(nHeight*nRow), nLeft, nTop+(nHeight*nRow), nRight, 1, "I")
  NEXT

  ****
  * Draw boxes for numbers
  ****
  nCol := nDow - 1
  nRow := 0
  FOR nDay = 1 TO nDays

    hpGrayBox(nTop+(nHeight*nRow)+.03, nLeft+(nCol*nWidth)+.05, nTop+(nHeight*nRow)+.34+.03, nLeft+(nCol*nWidth)+.29+.05, 1, 1, "I")
    hpGrayBox(nTop+(nHeight*nRow)-.02, nLeft+(nCol*nWidth), nTop+(nHeight*nRow)+.03, nLeft+(nCol*nWidth)+.29, 0, 100, "I")
    hpGrayBox(nTop+(nHeight*nRow)-.02, nLeft+(nCol*nWidth), nTop+(nHeight*nRow)+.34, nLeft+(nCol*nWidth)+.05, 0, 100, "I")
    hpCenter(hpBold(LTRIM(STR(nDay))), nTop+(nHeight*nRow)+.2, nLeft+(nCol*nWidth)+.22 , "I")

    IF nCol == 6
      nCol := 0
      nRow++
    ELSE
      nCol++
    ENDIF
  NEXT

  hpClrFonts()
  hpReset()

  hpPrintOff()

  SETCOLOR('w/b')
  @ 3,0 CLEAR

  ShowBox('Finished Printing.')
  SETCOLOR(cOldColor)
  TONE(100,1)
  TONE(500,1)
  TONE(1000,1)
  inkey(1)

RETURN NIL

* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ *
FUNCTION getinput(nMonth, nYear)

  MEMVAR GETLIST

  setcolor('w/b')
  @ 3,0 CLEAR
  @ 9,11,15,68 BOX 'Ŀ ' COLOR 'n/w'
  Shadow(9, 11, 15, 68)

  SETCOLOR('w+/w, w+/br,,,w+/n')
  @ 11,14 SAY 'What month and year would you like the calendar for?'
  @ 13,14 SAY '  Month     Year       (ie. 1 1993 = January 1993)'
  @ 13,22 GET nMonth PICTURE '99'   VALID nMonth > 0 .AND. nMonth < 13
  @ 13,31 GET nYear  PICTURE '9999' VALID nYear > 0

  READ

  setcolor('w/b')
  @ 3,0 CLEAR

RETURN IIF( LASTKEY() == 27, .F., .T.)

* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ *
****
* Calculate the first and last day of the month, and the number of
* days in the month.
****
FUNCTION calcdays(nMonth, nYear, dFirstDay, dLastDay, nDow, nDays)

  dFirstDay := CTOD(ALLTRIM(STR(nMonth)) + '/' + '01' + '/' + ALLTRIM(STR(nYear)))
  IF nMonth == 12
    dLastDay := CTOD('12/31/'+ALLTRIM(STR(nYear)))
  ELSE
    dLastDay  := CTOD(ALLTRIM(STR(nMonth+1)) + '/' + '01' + '/' + ALLTRIM(STR(nyear))) - 1
  ENDIF

  nDow  := DOW(dFirstDay)
  nDays := DAY(dLastDay)

RETURN NIL

