#define INCL_32

#include <stdio.h>
#include <string.h>

/* OS/2 */

#define INCL_NOCOMMON
#define INCL_DOSPROCESS
#define INCL_DOSDATETIME
#define INCL_DOSMISC
#define INCL_DOSSEMAPHORES
#define INCL_DOSFILEMGR
#include <os2.h>

/* net */

#include "netcons.h"
#include "service.h"
#include "neterr.h"
#include "use.h"
#include "shares.h"
#include "wksta.h"

static struct file_info_1 fileinfo[100];
static struct use_info_0 useinfo[50];
static struct session_info_2 sessinfo[50];
static struct service_info_0 svcinfo0[50];
static struct service_info_2 svcinfo;

static ULONG Reserved=0;
static APIRET rc;

static USHORT nread,navail,nretry,needretry;

static HEV SemHandle;         /* semaphore handle for AsyncTimer */

static int i;
static char slashstring[40];

static void wait100(void);

int main(void)
{

/* in trap or hard error, stop without a pop-up window */

DosError(FERR_DISABLEHARDERR | FERR_DISABLEEXCEPTION);

/* close files: SERVER only */

rc=NetFileEnum(NULL,NULL,1,(char *)fileinfo,sizeof(fileinfo),&nread,&navail);
if (rc==0) /* skip if wksta */
 for (i=0; i<nread; i++)
  {
  /*
  printf("Closing file %s for %s.\n",fileinfo[i].fi1_pathname,fileinfo[i].fi1_username);
  */
  rc=NetFileClose(NULL,fileinfo[i].fi1_id);
  }

/* close uses: WKSTA as well */

rc=NetUseEnum(NULL,0,(char *)useinfo,sizeof(useinfo),&nread,&navail);
if (rc==0)
 for (i=0; i<nread; i++)
  {
  rc=NetUseDel(NULL,useinfo[i].ui0_local,USE_LOTS_OF_FORCE);
  if (rc!=0) /* If error, try remote name: 3Com hack */
   rc=NetUseDel(NULL,useinfo[i].ui0_remote,USE_LOTS_OF_FORCE);
/* rc=2550 if, e.g., a remote drive is current for some process - OK */
  }

/* It would be nice to logoff users to update DCDB properly
   but there doesn't seem to be such an API! */

/*
rc=NetLogonEnum(NULL,2,(char *)logoninfo,sizeof(logoninfo),&nread,&navail);
if (rc==0)
 for (i=0; i<nread; i++)
  {
  printf("Logging off %s on %s.\n",
   logoninfo[i].usrlog2_eff_name,logoninfo[i].usrlog2_computer);
  rc=Net???(NULL,logoninfo[i].usrlog2_eff_name);
  }
*/

/* close sessions */

rc=NetSessionEnum(NULL,2,(char *)sessinfo,sizeof(sessinfo),&nread,&navail);
if (rc==0)
 for (i=0; i<nread; i++)
  {
  strcpy(slashstring,"\\\\");
  strcat(slashstring,sessinfo[i].sesi2_cname);
/*
  printf("Deleting session %s (%s,%s).\n",slashstring,
  sessinfo[i].sesi2_username,
  sessinfo[i].sesi2_cltype_name);
*/
  rc=NetSessionDel(NULL,slashstring,0);
  }

/* close shares --- not really necessary

rc=NetShareEnum(NULL,2,(char *)sharinfo,sizeof(sharinfo),&nread,&navail);
if (rc==0)
 for (i=0; i<nread; i++)
  {
  printf("Deleting share %s / %s / %s",sharinfo[i].shi2_netname,
   (sharinfo[i].shi2_type==STYPE_DISKTREE ? "disk" :(
   sharinfo[i].shi2_type==STYPE_PRINTQ ? "printer" :(
   sharinfo[i].shi2_type==STYPE_DEVICE ? "device" :(
   sharinfo[i].shi2_type==STYPE_IPC ? "IPC" :
                               "unknown type!"
   )))),
   sharinfo[i].shi2_remark,sharinfo[i].shi2_path);
  if (*sharinfo[i].shi2_path)
   printf(" / %s",sharinfo[i].shi2_path);
  if (sharinfo[i].shi2_current_uses)
   printf(" (%u user(s))",sharinfo[i].shi2_current_uses);
  printf(".\n");
  rc=NetShareDel(NULL,sharinfo[i].shi2_netname,0);
  }

*/

/* stop services: WKSTA and SERVER */

/* Create event semaphore used by wait100 */
rc=DosCreateEventSem("\\SEM32\\SHDOASYNCTIMER",&SemHandle,0,0);

nretry=100;
while(nretry)
 {
 needretry=0;
 rc=NetServiceEnum(NULL,0,(char *)svcinfo0,sizeof(svcinfo0),&nread,&navail);
 if (rc==0)
  for (i=nread-1; i>=0; i--) /* top to bottom */
   {
   rc=NetServiceControl(NULL,svcinfo0[i].svci0_name, SERVICE_CTRL_UNINSTALL,
    0, (char *)&svcinfo, sizeof(svcinfo) );
 switch(rc)
  {
  case 0:
   if ((svcinfo.svci2_status&SERVICE_INSTALL_STATE)!=SERVICE_UNINSTALLED)
    {
    needretry=1;
    }
  case NERR_ServiceEntryLocked:
  case NERR_ServiceCtlBusy:
  case NERR_ServiceTableLocked:
  case NERR_ServiceCtlTimeout:
   needretry=1;
   break;
  case NERR_ServiceNotCtrl:
  case NERR_ServiceNotInstalled:
  case NERR_ServiceKillProc:
  case NERR_ServiceCtlNotValid:
  default:
   break;
  }
  }
 if (needretry)
  {
  wait100();
  nretry--;
  }
 else
  nretry=0;
 }

/* if we wanted to shut down in a more cute way,

#define INCL_WINWORKPLACE

if ((hab=WinInitialize(0))!=0)
 {
 if ((hmq=WinCreateMsgQueue(hab,0))!=0L)
  {
  rc=WinShutdownSystem(hab, hmq);
  }
 }

*/


/* from prog guide vol I p. 2-14: */

rc=DosShutdown(Reserved);
DosBeep(1380,1000); /* indicate that shutdown has started */
for(;;); /* freeze forever --- calling any function crashes the system */

}

void wait100(void)
{

rc=DosResetEventSem(SemHandle,&rc);

rc=DosAsyncTimer(100,(HSEM)SemHandle,&rc);

rc=DosWaitEventSem(SemHandle,200);

}
