#include <stdio.h>
#include <conio.h>

#include "nos.h"
#include "noslib.h"
#include "netusers.h"
#include "proto.h"

extern struct serverdef *server;
extern struct localuserlistdef *localuserlist;
extern struct localuserlistdef *previous_localuserlist;
extern struct localuserlistdef *startup_localuserlist;

extern int currentserver, adaptornum, numberoflogins, currentprinter, found;
extern int userlistjobcount, printjobcount;
extern int maxlocaluserlistcount, localuserlistcount;
extern int monoflag, singleflag;


void reportinfo ()
    {
    //report server name & time

    currentserver = 0;
    while (currentserver < numberoflogins)
	{
	highlight ();
	if (singleflag)
	    printf ("%-15s", server [currentserver] .servername);
	else
	    cprintf ("%-15s", server [currentserver] .servername);

	nohighlight ();
	if (singleflag)
	    {
	    printf ("%*s%02d/%02d/%04d %02d:%02d:%02d", 42,"",
		server [currentserver] .time.TB_month,
		server [currentserver] .time.TB_day,
		server [currentserver] .time.TB_year,
		server [currentserver] .time.TB_hour,
		server [currentserver] .time.TB_minutes,
		server [currentserver] .time.TB_seconds);
	    printf ("\r\n");
	    }
	else
	    {
	    cprintf ("%*s%02d/%02d/%04d %02d:%02d:%02d", 42,"",
		server [currentserver] .time.TB_month,
		server [currentserver] .time.TB_day,
		server [currentserver] .time.TB_year,
		server [currentserver] .time.TB_hour,
		server [currentserver] .time.TB_minutes,
		server [currentserver] .time.TB_seconds);
	    cprintf ("\r\n");
	    }

	reportuserlist ();

	currentserver++;
	}
    }



void reportuserlist ()
    {
    //report each server's user list

    int linecount;

    printjobcount = 0;

    linecount = -1;
    cprintf ("\r\n");

    while (printjobcount < localuserlistcount)
	{
	if (localuserlist [printjobcount] .server == currentserver)
	    {
	    if (++linecount == 3)
		{
		linecount = 0;
		if (singleflag)
		    printf ("\r\n");
		else
		    cprintf ("\r\n");
		}

	    highlight_active_machine ();

	    if (singleflag)
		printf ("%-25s ", localuserlist [printjobcount] .name_machine);
	    else
		cprintf ("%-25s ", localuserlist [printjobcount] .name_machine);

	    nohighlight ();
	    }
	printjobcount++;
	}

    if (singleflag)
	{
	printf ("\r\n");
	printf ("\r\n");
	}
    else
	{
	cprintf ("\r\n");
	cprintf ("\r\n");
	}
    }


int getextch ()
    {
    //	gets value of extended key press

    int c;

    c = getch ();
    if (c == 0)
	{
	c = getch ();
	if (c < 128)
	    c += 128;
	}
    return (c);
    }


void highlight ()
    {
    //	sets colors for active servers

    if (!monoflag)
	textcolor (BROWN);
    highvideo ();
    }


void nohighlight ()
    {
    //	sets colors for server time & local users

    if (!monoflag)
	textcolor (CYAN);
    lowvideo ();
    }


void errorhighlight ()
    {
    //	sets colors for error messages

    if (!monoflag)
	textcolor (RED);
    highvideo ();
    }


void highlight_active_machine ()
    {
    //	sets colors for active users

    if (userrequest_since_startup () )
	{
	if (monoflag)
	    highvideo ();
	else
	    {
	    textcolor (GREEN);
	    if (userrequest_since_update () )
		highvideo ();
	    else
		lowvideo ();
	    }
	}
    }


int userrequest_since_startup ()
    {
    int i, j;

    for (i = 0; i < maxlocaluserlistcount; i++)
	{
	if ((strcmp (startup_localuserlist [i] .AUE_machine,
	     localuserlist [printjobcount] .AUE_machine) == 0) &&
	    (startup_localuserlist [i] .server ==
	     localuserlist [printjobcount] .server))
	    {
	    for (j = 0; j < 3; j++)
		{
		if (startup_localuserlist [i] .AUE_requests [j]  !=
		    localuserlist [printjobcount] .AUE_requests [j])
		    {
		    return true;
		    }
		}
	    return false;
	    }
	}

    return true;
    }


int userrequest_since_update ()
    {
    int i, j;

    for (i = 0; i < maxlocaluserlistcount; i++)
	{
	if ((strcmp (previous_localuserlist [i] .AUE_machine,
	     localuserlist [printjobcount] .AUE_machine) == 0) &&
	    (previous_localuserlist [i] .server ==
	     localuserlist [printjobcount] .server))
	    {
	    for (j = 0; j < 3; j++)
		{
		if (previous_localuserlist [i] .AUE_requests [j]  !=
		    localuserlist [printjobcount] .AUE_requests [j])
		    {
		    return true;
		    }
		}
	    return false;
	    }
	}

    return true;
    }

void message (char *messagetext, int eraseflag)
    {
    //	displays message in center of the first line of the screen

    gotoxy ( (40 - (strlen (messagetext) / 2) ), 1);
    errorhighlight ();
    cprintf ("%s", messagetext);
    nohighlight ();

    if (eraseflag == true)
	sleep (3);
    }
