#include <stdio.h>
#include <conio.h>

#include "nos.h"
#include "noslib.h"
#include "netusers.h"
#include "proto.h"

extern struct serverdef *server;
extern struct localuserlistdef *localuserlist;
extern struct localuserlistdef *previous_localuserlist;
extern struct localuserlistdef *startup_localuserlist;

extern int currentserver, adaptornum, numberoflogins, currentprinter, found;
extern int userlistjobcount, printjobcount;
extern int maxlocaluserlistcount, localuserlistcount;

extern struct PS serverps;
extern struct time_block servertime;
extern struct active_user_entry serveraue;


void getserverinfo ()
    {
    char buf [2 * D_NAMESZ + 10];
    int i;

    //	Loop through each server that the user is logged into

    purgelocaluserlist ();

    currentserver = 0;
    localuserlistcount = 0;

    while (currentserver < numberoflogins)
	{
	//  Record the Server's Date & Time

	if (NOSGetTime (&servertime, server [currentserver] .servername) == -1)
	    NOSperror ("NOSGetTime");
	else
	    server [currentserver] .time = servertime;

	currentserver++;
	}

    currentserver = 0;
    localuserlistcount = 0;

    while (currentserver < numberoflogins)
	{
	//	Import Active User List from current server

	userlistjobcount = 0;
	printjobcount = 0;

	while (NOSGetUserInfo (&userlistjobcount, &serveraue, server [currentserver] .servername) != -1)
	    {
	    if (localuserlistcount >= maxlocaluserlistcount)
		{
		if ( (localuserlist = (struct localuserlistdef *)
			realloc (localuserlist,
			localuserlistcount * sizeof (struct localuserlistdef)))
			==  (struct localuserlistdef *) 0)
		    {
		    printf ("Couldn't reallocate space for userlist\n");
		    exit (1);
		    }

		if ( (startup_localuserlist = (struct localuserlistdef *)
			realloc (startup_localuserlist,
			localuserlistcount * sizeof (struct localuserlistdef)))
			==  (struct localuserlistdef *) 0)
		    {
		    printf ("Couldn't reallocate space for previous userlist\n");
		    exit (1);
		    }

		if ( (previous_localuserlist = (struct localuserlistdef *)
			realloc (previous_localuserlist,
			localuserlistcount * sizeof (struct localuserlistdef)))
			==  (struct localuserlistdef *) 0)
		    {
		    printf ("Couldn't reallocate space for previous userlist\n");
		    exit (1);
		    }

		maxlocaluserlistcount++;
		}
	    strcpy (localuserlist [localuserlistcount] .AUE_machine,
		serveraue .AUE_machine);

	    i = strlen (serveraue .AUE_machine);
	    while (serveraue .AUE_machine [--i] == ' ');
	    serveraue .AUE_machine [++i] = '\0';

	    if (serveraue .AUE_VCID < 0x100)
		sprintf (buf, "%s @ %s\0", serveraue .AUE_name,
		    serveraue .AUE_machine);
	    else
		sprintf (buf, "%s @ %s *\0", serveraue .AUE_name,
		    serveraue .AUE_machine);

	    buf [25] = '\0';

	    strcpy (localuserlist [localuserlistcount] .name_machine, buf);

	    for (i = 0; i < 3; i++)
		localuserlist [localuserlistcount] .AUE_requests [i] =
		    serveraue .AUE_requests [i];

	    localuserlist [localuserlistcount] .server	  = currentserver;
	    localuserlistcount++;
	    }
	currentserver++;
	}
    qsort ( (void *) localuserlist, localuserlistcount, sizeof (struct localuserlistdef), comparestring);
    }



void purgelocaluserlist ()
    {
    int i;

    for (i = 0; i < maxlocaluserlistcount + 1; i++)
	localuserlist [i] .server = -1;
    }
