#include <string.h>

#ifndef CUSTOM_H
// Initialiation file
#define SRC_SECTION   "Sources"
#define DST_SECTION   "Destinations"

// Common entry points
#define MAGICPROC           "Magic"
#define GETDESCRIPTIONPROC  "GetDescription"
#define GETEXTENSIONPROC    "GetExtension"
#define GETFLAGSPROC        "GetFlags"
#define SETOPTIONSPROC      "SetOptions"
#define CLEANUPPROC         "CleanUp"

// Reader entry points
#define READHEADERPROC      "ReadHeader"
#define READROWPROC         "ReadRow"
#define READFILEPROC        "ReadFile"

// Writer entry points
#define WRITEHEADERPROC     "WriteHeader"
#define WRITEROWPROC        "WriteRow"
#define WRITEFILEPROC       "WriteFile"
#define ENDWRITEPROC        "EndWrite"


// Color palette type
typedef BYTE PAL[3][256];
typedef BYTE * PPAL[256];
typedef BYTE FAR * LPPAL[256];

// I/I means INPUT parameter for both ReadHeader and WriteHeader
// O/I means OUTPUT parameter for ReadHeader and INPUT for WriteHeader
// O/O means OUTPUT parameter for both ReadHeader and WriteHeader

// Parameter block for ReadHeader / WriteHeader
typedef struct
{
    OFSTRUCT of;    // I/I Opened Source/Destination file
    int  file;      // I/I             --/--
    WORD w;         // O/I Width
    WORD h;         // O/I Height
    WORD bps;       // O/I 1,4,8 or 24
    WORD numcolors; // O/I Actual number of colors/shades ( 0 for bps == 24 )
    WORD nplanes;   // O/O Number of bitplanes
    WORD bplin;     // O/O Bytes per one bitplane
    DWORD   xres;   // O/I X Resolution
    DWORD   yres;   // O/I Y Resolution
    WORD    resunit;// O/I Resolution unit (See below)
    DWORD   flags;  // ??? Miscellaneous flags (See below)
    PAL     pal;    // O/I Color palette
} INFO;

typedef INFO * PINFO;
typedef INFO FAR * LPINFO;

// Values for resunit
#define RES_UNKNOWN     0
#define RES_NOUNIT      1
#define RES_SCREEN      2
#define RES_DPI         3
#define RES_DPCM        4
#define RES_DPM         5

// Bits for INFO.flags
// Color info bits
#define INFO_COLOR      1l      // O/I Image is colored
#define INFO_PALETTE    2l      // O/I Image is paletted
#define INFO_NEGATIVE   4l      // O/I Image is negative
// File organization bits
#define INFO_TEMPFILE   8l      // O/O Only by temporary file
#define INFO_COMPRESSED 0x10l   // O/O Image is compressed
#define INFO_FORWARD    0x20l   // O/O Up to down
#define INFO_BACKWARD   0x40l   // O/O Down to up
#define INFO_RANDOM     0x80l   // O/O Random access is allowed
// Row organization bits
#define INFO_PACKED     0x100l  // O/O (bps < 8) bits are shifted together
#define INFO_SEPARATE   0x200l  // O/O (bps !=8) bitplanes are separated

// Bits for GetFlags()
// Destination capabilites bits
#define INFO_1BPS       0x400l  // -/O  Accepts 1-bit data
#define INFO_4BPS       0x800l  // -/O  Accepts 4-bit data
#define INFO_8BPS       0x1000l // -/O  Accepts 8-bit data
#define INFO_24BPS      0x2000l // -/O  Accepts 24-bit data
#define INFO_GRAY       0x4000l // -/O  Accepts true gray data
#define INFO_STDPAL     0x8000l // -/O  Requires std. EGA/VGA palette
#define INFO_ANYPAL     0x10000l// -/O  Accepts any palette
// Source/Destination capabilites bits
#define INFO_HASOPTIONS 0x20000l// O/O  Has SetOptions()
#define INFO_NOFILE     0x40000l// O/O  Do not open src/dst file

// ALL OTHER BITS ARE RESERVED

// Return values for Magic
#define SRC_MAGIC   0x1234
#define DST_MAGIC   0x4321

// Common return values
#define OK          0
#define BADFORMAT   1   // Bad signature
#define UNSUPPORTED 2   // Unsupported subformat
#define BADFILE     3   // Error in file structure
#define CANNOTOPEN  4   // Cannot open src/dest
#define INTERNAL    5   // Reserved
#define BADDLL      6   // Error initializing DLL
#define BADREQUEST  7   // Unsupported type of conversion
#define BADTEMPFILE 8   // Error creating/reading tempfile
#define NOMEMORY    9   // No enough global heap
#define NODISK      10  // No enough disk space
#define USERABORT   11  // Cancelled by user
#define BADPARMS    12  // Conflicting parameters

WORD  FAR PASCAL Magic(void);
void  FAR PASCAL GetDescription(LPSTR);
void  FAR PASCAL GetExtension(LPSTR);
DWORD FAR PASCAL GetFlags(void);
int   FAR PASCAL SetOptions(HWND,void far *);
int   FAR PASCAL GetPrivateSize(void);
void  FAR PASCAL CleanUp(void far *);

int   FAR PASCAL ReadHeader(LPINFO,void far * );
int   FAR PASCAL ReadRow(int,LPBYTE,void far *);
int   FAR PASCAL ReadFile(int, void far *, FARPROC);

int   FAR PASCAL WriteHeader(LPINFO,void far * );
int   FAR PASCAL WriteRow(int,LPBYTE,void far *);
int   FAR PASCAL WriteFile(int,void far *, FARPROC);
int   FAR PASCAL EndWrite(void far *);
#define CUSTOM_H
#endif
