/***********************************************************************
*$Header:   J:/gedcom/gedlib/vcs/gedprint.c_v   1.4   03 Mar 1992 09:37:18   fhdodj  $
*
*$config$="/K! /L/* /R* /Mgedprint.c"
*!global paths!
*   gedcom\library\gedprint.c
*   gedcom\all\gedprint.c
*!end!
*
*   FILE NAME: GEDPRINT.C
*
*   DESCRIPTION:
*       This file contains functions for displaying trees.
*
*   ROUTINES:
*
*
*$Log:   J:/gedcom/gedlib/vcs/gedprint.c_v  $
 * 
 *    Rev 1.4   03 Mar 1992 09:37:18   fhdodj
 * Removed fflush from file.
 * 
 *    Rev 1.3   21 Oct 1991 11:22:02   fhdodj
 * Changed char to byte.
 * 
 *    Rev 1.2   28 Jun 1991 14:59:14   fhdkrf
 * Added keywords for PolyDoc
 * 
 *    Rev 1.1   07 May 1991 14:39:36   odj
 * Changed char * and void * to fix problem with prototypes. added to 
 * ged_print_ .. functions ability to count and return number of lines printed.
 * 
 *    Rev 1.1   07 May 1991 14:21:16   odj
 * Fixed type problems with void * and char *, and added ability to count
 * lines in ged_print.. functions.
 * 
 *    Rev 1.0   20 Dec 1990 09:04:14   odj
 * Initial revision.
***********************************************************************/
#include "gedcom.h"

/********************************************************************
*!name!
*    ged_indent_line()
*!1!
*
*        NAME: ged_indent_line
*
*        DESCRIPTION:
*            outputs a line to a stream with the correct indentation.
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
int ged_indent_line(level, node, tStream, tLineCount)
    int   level;
    NODE *node;
#ifdef NON_ANSI
    byte *tStream;
    byte *tLineCount;
#else
    void *tStream;
    void *tLineCount;
#endif
    {			/*!end!*/
    FILE *stream = (FILE *) tStream;
    int *lineCount = (int *) tLineCount;
    int count;
    int indentLevel = 2 * level;

        *lineCount = *lineCount + 1;
        for(count = 0; count < indentLevel; count++)
            fprintf(stream, " ");
        fprintf(stream, "%s\n", node->line);
        return(1);
    }

/********************************************************************
*!name!
*    ged_output_level()
*!1!
*
*        NAME: ged_output_level
*
*        DESCRIPTION:
*            outputs a line with it's level to stream.
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
int ged_output_level(level, node, tStream, tLineCount)
    int   level;
    NODE *node;
#ifdef NON_ANSI
    byte *tStream;
    byte *tLineCount;
#else
    void *tStream;
    void *tLineCount;
#endif
    {			/*!end!*/
    FILE *stream = (FILE *) tStream;
    int  *lineCount = (int *) tLineCount;

        *lineCount = *lineCount + 1;
        fprintf(stream, "%d %s\n", level, node->line);
        return(1);
    }
/**/
/********************************************************************
*!name!
*    ged_print_levels()
*!1!
*
*        NAME: ged_print_levels
*
*        DESCRIPTION:
*            Does a preorder traversal of the input tree and prints it
*            with level numbers.
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
int ged_print_levels(tree, stream)
    NODE *tree;
    FILE *stream;
    {			/*!end!*/
    int lineCount = 0;

        ged_apply_tree(tree, 0, 0, ged_output_level, stream, &lineCount);
        return(lineCount);
    }

/********************************************************************
*!name!
*    ged_print_indented()
*!1!
*
*        NAME: ged_print_indented
*
*        DESCRIPTION:
*            Does a preorder traversal of the input tree and prints it
*            indenting each level to stream.
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
int ged_print_indented(tree, stream)
    NODE *tree;
    FILE *stream;
    {			/*!end!*/
    int lineCount = 0;

        ged_apply_tree(tree, 0, 0, ged_indent_line, stream, &lineCount);
        return(lineCount);
    }
