#ifndef BYTE
typedef unsigned char byte;
#define BYTE
#endif

/*
        STRUCT: memChunk
        PURPOSE:
            Contains pointers to the start, end, the place
            where memory will next be allocated from, and
            a pointer to the next chunk.
*/
struct memChunk {
    unsigned long size,
                  free;
    byte *bufPtr,
         *curPtr,
         *endPtr;
    struct memChunk *nextChunk;
};

/*
      STRUCT: pool
        PURPOSE:
            Contains addresses to functions to allocate memory
            from the pool, reset the pool's memory, or destroy
            the pool. It also contains a pointer to a chain of
            all the pools memory. size is the size to grow the
            pool, and nodeSize is the default node size.
*/
#ifdef NON_ANSI
struct pool {
    byte * (* ged_alloc_pool) ();
    short  (* ged_reset_pool) ();
    void   (* ged_destroy_pool) ();
    unsigned size;
    unsigned nodeSize;
    struct memChunk *firstChunk;
};
#else
struct pool {
    byte * (* ged_alloc_pool) (unsigned long);
    short  (* ged_reset_pool) (void);
    void   (* ged_destroy_pool) (void);
    unsigned size;
    unsigned nodeSize;
    struct memChunk *firstChunk;
};
#endif

struct chunkMarker
    {
    struct chunkMarker * nextMarker;
    struct memChunk    * markedChunk;
    byte               * writePtr;
    byte               * readPtr;
    byte               * savePtr;
    unsigned long      saveFree;
    unsigned long      free;
    unsigned long      read;
    unsigned long      size;
    };

/**/
#ifndef NODE_DEFINED
#define NODE_DEFINED
/*
        STRUCT: InternalNode
        PURPOSE:
            Definition of the internal node
*/
struct InternalNode {
    byte   *line;
    struct InternalNode *parent;
    struct InternalNode *child;
    struct InternalNode *sibling;
    unsigned int length;
};
typedef struct InternalNode NODE;
#endif

typedef struct pool          POOL;
typedef struct memChunk      CHUNK;

typedef struct chunkMarker	CHUNKMARKER;

/* Functions in stdmem.c */
#ifdef NON_ANSI
byte *   ged_alloc_pool();
void     ged_check_mem();
byte *   ged_copy_marked_mem();
POOL *   ged_create_pool();
void     ged_destroy_pool();
CHUNK *  ged_get_chunk();
POOL  *  ged_get_pool();
CHUNKMARKER * ged_mark_mem();
CHUNKMARKER * ged_put_byte_mem();
byte     ged_remove_byte_mem();
short    ged_reset_pool();
POOL  *  ged_set_pool();
#else
#ifdef __cplusplus
extern "C" {
#endif

byte *   ged_alloc_pool(unsigned long);
void     ged_check_mem( void );
byte *   ged_copy_marked_mem(CHUNKMARKER *);
POOL *   ged_create_pool(unsigned, unsigned);
void     ged_destroy_pool(void);
CHUNK *  ged_get_chunk(unsigned long);
POOL  *  ged_get_pool(void);
CHUNKMARKER * ged_mark_mem(unsigned long);
CHUNKMARKER * ged_put_byte_mem(byte, CHUNKMARKER **);
byte     ged_remove_byte_mem(CHUNKMARKER **);
short    ged_reset_pool(void);
POOL  *  ged_set_pool(POOL *);

#ifdef __cplusplus
}
#endif
#endif

#define GED_ALLOC_POOL(X)  (ged_get_pool() ? \
                            (*(ged_get_pool()->ged_alloc_pool))(X): NULL)
#define GED_RESET_POOL()   if (ged_get_pool()) \
                                (*(ged_get_pool()->ged_reset_pool))()
#define GED_DESTROY_POOL() if (ged_get_pool()) \
                                (*(ged_get_pool()->ged_destroy_pool))()

#ifndef WORD_SIZE
#define WORD_SIZE       sizeof(int)
#endif
