/***********************************************************************
*$Header:   J:/gedcom/gedlib/vcs/gedaskst.c_v   1.4   26 Mar 1992 10:29:44   fhdodj  $
*
*$config$="/K! /L/* /R* /Mgedaskst.c"
*!global paths!
*   gedcom\library\gedaskst.c
*   gedcom\all\gedaskst.c
*!end!
*
*   FILE NAME: GEDASK.C           
*
*   DESCRIPTION:
*       This file contains functions which find context within a record
*
*   ROUTINES:
*       NODE * ged_ask_string(NODE * obj, byte * msg, int nth)
*       NODE * ged_hunt_tags_string(NODE * obj, byte * msg, int *nth)
*
*   MODIFICATION HISTORY:
*
*$Log:   J:/gedcom/gedlib/vcs/gedaskst.c_v  $
 * 
 *    Rev 1.4   26 Mar 1992 10:29:44   fhdodj
 * Replaced tmpPos with ged_skip_word in ged_hunt_tags.
 * 
 *    Rev 1.3   25 Mar 1992 15:43:40   fhdodj
 * Added function ged_ask_partial_string().
 * 
 *    Rev 1.2   21 Oct 1991 09:04:58   fhdodj
 * Changed char to byte.
 * 
 *    Rev 1.1   28 Jun 1991 11:39:52   fhdkrf
 * Added keywords for PolyDoc
 * 
 *    Rev 1.0   17 Jun 1991 12:23:20   odj
 * Initial revision.
***********************************************************************/

#include "gedcom.h"

/********************************************************************
*!name!
*    ged_ask_string()
*!1!
*
*        NAME: ged_ask_string
*
*        DESCRIPTION:
*            Gets the nth occurance of the node in obj at the end of
*            the path msg. In the future, if there is no value, an
*            attempt will be made to compute a value. This function
*            is identical to ged_ask except that the path it uses 
*            is a string consisting of tags, instead of a tree.
*
*        RETURN VALUE:
*            Returns the nth occurance of the node at the end of the
*            path or NULL if unsuccesful. If a value less than 0 is
*            given for nth, the first value will be returned. If a
*            value greater than the number of occurances is given,
*            NULL will be returned.
*
*        CALLS: ged_get_child, ged_hunt_tags_string
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
NODE * ged_ask_string(obj, msg, nth)
    NODE *obj;  /* The tree in which we will follow path msg */
    byte *msg;  /* The path to follow */
    int   nth;  /* Which occurance to return */
    {			/*!end!*/

        if ( !msg && (nth < 2) ) /* If no msg and we are looking for the */
            return(obj);         /* first occurance we are already there */
        if ( !msg || !*msg )  /* If no msg and we are not looking for the */
            return(NULL);     /* next occurance, there isn't one */
        obj = ged_get_child(obj);
        if ( !obj )  /* If no tree to look in, we must fail. */
            return(NULL);
        return(ged_hunt_tags_string(obj, msg, &nth));
    }
/**/
/********************************************************************
*!name!
*    ged_ask_string()
*!1!
*
*        NAME: ged_ask_partial_string
*
*        DESCRIPTION:
*            Gets the nth occurance of the node in obj at the end of
*            the partial path msg. In the future, if there is no value, an
*            attempt will be made to compute a value. This function
*            is identical to ged_ask_partial except that the path it uses 
*            is a string consisting of tags, instead of a tree.
*
*        RETURN VALUE:
*            Returns the nth occurance of the node at the end of the
*            path or NULL if unsuccesful. If a value less than 0 is
*            given for nth, the first value will be returned. If a
*            value greater than the number of occurances is given,
*            NULL will be returned.
*
*        CALLS: ged_get_child, ged_hunt_tags_string
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
NODE * ged_ask_partial_string(obj, msg, nth)
    NODE *obj;  /* The tree in which we will follow path msg */
    byte *msg;  /* The path to follow */
    int   nth;  /* Which occurance to return */
    {			/*!end!*/
    NODE *ret_val;
    NODE *tmp_obj;
    NODE *start_obj = obj;

        if ( !msg && (nth < 2) ) /* If no msg and we are looking for the */
            return(obj);         /* first occurance we are already there */
        if ( !msg || !*msg )  /* If no msg and we are not looking for the */
            return(NULL);     /* next occurance, there isn't one */
        if ( nth <= 0 )
	    nth = 1;
	while(obj && (nth > 0))
	    {
	    tmp_obj = ged_get_child(obj);
	    if (tmp_obj)
                ret_val = ged_hunt_tags_string(tmp_obj, msg, &nth);
            if ((obj = ged_get_next_node(obj)) == start_obj)
                {
	        obj = NULL;
		ret_val = NULL;
		}
	    }
        return(ret_val);
    }
/**/
/********************************************************************
*!name!
*    ged_hunt_tags_string()
*!1!
*
*        NAME: ged_hunt_tags_string
*
*        DESCRIPTION:
*            Traverses the path in msg to find the nth occurance of
*            the node in the tree obj at the end of the path.
*
*        RETURN VALUE:
*            The nth occurance of the node at the end of the path
*            msg in obj, or NULL if not found. If a value less than
*            one is given for nth, the first occurance will be
*            returned. If a value for nth is given that is greater
*            than the number of occurances, NULL will be returned.
*
*        CALLS: 
*
*        CALLED BY: ged_ask_string
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
NODE * ged_hunt_tags_string(obj, msg, nth)
    register NODE *obj;  /* The tree to look in */
    byte *msg;           /* The path describing what to look for */
    int  *nth;           /* Which occurance to return */
    {			/*!end!*/
    NODE *lastObj = obj->parent;  /* contains the last obj position */
    NODE *start = obj->parent;    /* tells where we started. */
    byte *msgStart = msg;
    byte *tmpPos;

        while (isspace(*msg))
            msg++;
        while (msg)
            {

            /* find the next part of the path                   */
            while (obj && ged_match(ged_get_tag(obj), msg))
                obj = obj->sibling;

            /* try again when no more obj or need next answer.  */
            if (!obj || (!ged_skip_word(msg) && (--(*nth) > 0)))
                {
                if (!obj)
                    {
                    obj = lastObj;
                    msg = ged_prev_word(msg, msgStart);
                    }
                while (!obj->sibling && msg)
                    {
                    obj = obj->parent;
                    msg = ged_prev_word(msg, msgStart);
                    }
                obj = obj->sibling;
                lastObj = ged_get_parent(obj);
                }

            /* if there is more in msg keep looking.            */
            else if (tmpPos = ged_skip_word(msg))
                {
                msg = tmpPos;
                lastObj = obj;
                obj = obj->child;
                }

            /* The right answer was found */
            else if (*nth <= 0)
                return(obj);
            }
        if (start->sibling == obj)
            return(NULL);
        return(obj);
    }
