/***********************************************************************
*$Header:   J:/gedcom/gedlib/vcs/gedtree.c_v   1.2   21 Oct 1991 11:23:54   fhdodj  $
*
*$config$="/K! /L/* /R* /Mgedtree.c"
*!global paths!
*   gedcom\library\gedtree.c
*   gedcom\all\gedtree.c
*!end!
*
*   FILE NAME: GEDTREE.C
*
*   DESCRIPTION:
*       This file contains a functions for traversing a tree, and applying
*       a function to each node.
*
*   ROUTINES:
*
*
*$Log:   J:/gedcom/gedlib/vcs/gedtree.c_v  $
 * 
 *    Rev 1.2   21 Oct 1991 11:23:54   fhdodj
 * Changed char to byte.
 * 
 *    Rev 1.1   28 Jun 1991 15:03:58   fhdkrf
 * Added keywords for PolyDoc
 * 
 *    Rev 1.0   20 Dec 1990 09:02:28   odj
 * Initial revision.
***********************************************************************/
#include "gedcom.h"

/********************************************************************
*!name!
*    ged_apply_tree()
*!1!
*
*        NAME: ged_apply_tree
*
*        DESCRIPTION:
*            apply a function to the tree.
*
*        RETURN VALUE:
*            None.
*
*        CALLED BY: ged_tree_to_ged, ged_tree_to_file, 
*                   ged_print_levels, ged_print_indented
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
NODE *ged_apply_tree(tree, startLevel, forestFlag, function, arg1, arg2)
    register NODE *tree;
    int   startLevel;
    int   forestFlag;
#ifdef NON_ANSI
    int   (*function)();
    byte *arg1;
    byte *arg2;
#else
    int   (*function)(int, NODE *, void *, void *);
    void *arg1;
    void *arg2;
#endif
    {			/*!end!*/
    register int level = startLevel;

        while ( tree )
            {
            while ( tree->child )
                {
                if(!(*function)( level, tree, arg1, arg2 ))
                    return(tree);
                level++;
                tree = tree->child;
                }
            if(!(*function)( level, tree, arg1, arg2 ))
                return(tree);
            while(!tree->sibling && (level > startLevel))
                {
                level--;
                tree = tree->parent;
                }
            if ((level <= startLevel) && !forestFlag)
                break;
            tree = tree->sibling;
            }
        return(NULL);
    }
