/***********************************************************************
*$Header:   J:/gedcom/gedlib/vcs/gedmisc.c_v   1.6   06 Nov 1992 10:42:12   fhdodj  $
*
*$config$="/K! /L/* /R* /Mgedmisc.c"
*!global paths!
*   gedcom\library\gedmisc.c
*   gedcom\all\gedmisc.c
*!end!
*
*   FILE NAME: GEDMISC.C
*
*   DESCRIPTION:
*       This file contains functions for miscelaneous actions to be
*       preformed on nodes, records, or lines.
*
*   ROUTINES:
*       void   ged_clip_word(byte *);
*       byte * ged_skip_word(byte *);
*       byte * ged_prev_word(byte *, byte *);
*       int    ged_match(byte *, byte *);
*       int    ged_match_tags(NODE *, NODE *);
*       void   ged_strupr(byte *);
*       void   ged_strrev(byte *);
*
*
*$Log:   J:/gedcom/gedlib/vcs/gedmisc.c_v  $
 * 
 *    Rev 1.6   06 Nov 1992 10:42:12   fhdodj
 * Added new ged_match function.
 * 
 *    Rev 1.5   25 Mar 1992 15:57:06   fhdodj
 * Added ged_imatch() function. Case insensitive matching function.
 * 
 *    Rev 1.4   21 Oct 1991 10:12:26   fhdodj
 * Changed char to byte.
 * 
 *    Rev 1.3   28 Jun 1991 14:55:30   fhdkrf
 * Added keywords for PolyDoc
 * 
 *    Rev 1.2   18 Jun 1991 08:03:04   odj
 * Added ged_prev_word function.  Moved ged_strupr and ged_strrev functions to
 * this file.
 * 
 *    Rev 1.1   16 May 1991 13:37:12   odj
 * added ged_match functions to this file.
 * 
 *    Rev 1.0   20 Dec 1990 09:05:36   odj
 * Initial revision.
***********************************************************************/
#include "gedcom.h"

/*****************************************************************************
*!name!
*    ged_clip_word()
*!1!
*
*   NAME:   ged_clip_word
*
*   DESCRIPTION:
*       Takes out all trailing spaces from a word by adding a NULL byte
*       to the end of the word.
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
*****************************************************************************/
void ged_clip_word(ptr)
    byte *ptr;
    {			/*!end!*/
        if (!ptr || !*ptr)
            return;
        while (*ptr && !isspace(*ptr))
            ptr++;
        *ptr = '\0';
    }

/*****************************************************************************
*!name!
*    ged_skip_word()
*!1!
*
*   NAME:   ged_skip_word
*
*   DESCRIPTION:
*       Skips the word that wordPtr is pointing to and returns the address
*       of the next word.  NULL is returned if wordPtr is currently pointing
*       to the last word on a line.
*
*   RETURN VALUE:
*       Address of the next word on the line or NULL.
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
*****************************************************************************/
byte * ged_skip_word(wordPtr)
    byte *wordPtr;
    {			/*!end!*/
        /* Skip past present word */
        if ( !wordPtr || !*wordPtr )
                return( NULL );

        while (!isspace(*wordPtr) && (*wordPtr != '\0'))
                wordPtr++;
        /* Skip white spaces until next word or NULL is found */
        while (isspace(*wordPtr) && (*wordPtr != '\0'))
                wordPtr++;
        if ( !*wordPtr )
                return( NULL );
        else
                return( wordPtr );
    }

/*****************************************************************************
*!name!
*    ged_prev_word()
*!1!
*
*   NAME:   ged_prev_word
*
*   DESCRIPTION:
*       Skips the word that wordPtr is pointing to and returns the address
*       of the prev word.  NULL is returned if wordPtr is currently pointing
*       to the first word on a line.
*
*   RETURN VALUE:
*       Address of the prev word on the line or NULL.
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
*****************************************************************************/
byte * ged_prev_word(wordPtr, startLine)
    byte *wordPtr;
    byte *startLine;
    {			/*!end!*/

        if ( !wordPtr || !*wordPtr || !startLine )
                return( NULL );
        while (isspace(*startLine))
            startLine++;
        while (isspace(*wordPtr))
            wordPtr++;
        if ( wordPtr == startLine )
                return( NULL );

        /* Skip past present word */
        while (!isspace(*wordPtr) && (wordPtr != startLine))
                wordPtr--;

        /* Skip white spaces until prev word or startLine is found */
        while (isspace(*wordPtr) && (wordPtr != startLine))
               wordPtr--;

        /* go to beginning present word */
        while (!isspace(*wordPtr) && (wordPtr != startLine))
              wordPtr--;
        while (isspace(*wordPtr))
            wordPtr++;
        return( wordPtr );
    }

/********************************************************************
*!name!
*    ged_match()
*!1!
*
*        NAME: ged_match
*
*        DESCRIPTION:
*            Compares the first word on each of the two input lines.
*
*        RETURN VALUE:
*            Returns 0 if equal, or a non-zero value if not.
*
*        CALLED BY: ged_hunt_xref, ged_match_tags, ged_match_xrefs
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
int ged_match(line1, line2)
    byte *line1;
    byte *line2;
    {			/*!end!*/
    byte c1;
    byte c2;

        if (!line1 || !line2)
            return(1);
        c1 = *line1;
        c2 = *line2;
        while ((c1 == c2) && (c2 != '\0') && !isspace(c2))
            {
            c1 = *(++line1);
            c2 = *(++line2);
            }
        return(((c1 == c2) ||
                ((isspace(c1) || (c1 == '\0')) &&
                 (isspace(c2) || (c2 == '\0'))))
               ? 0 : 1);
    }
/**/
/********************************************************************
*!name!
*    ged_imatch()
*!1!
*
*        NAME: ged_imatch
*
*        DESCRIPTION:
*            Case insensitive comparison of the first word on each 
*            of the two input lines.
*
*        RETURN VALUE:
*            Returns 0 if equal, or a non-zero value if not.
*
*        CALLED BY: ged_hunt_xref, ged_match_tags, ged_match_xrefs
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
int ged_imatch(line1, line2)
    byte *line1;
    byte *line2;
    {			/*!end!*/
    byte c1;
    byte c2;

        if (!line1 || !line2)
            return(1);
        c1 = (islower(*line1) ? (byte)toupper(*line1) : *line1);
        c2 = (islower(*line2) ? (byte)toupper(*line2) : *line2);
        while ((c1 == c2) && (c2 != '\0') && !isspace(c2))
            {
            c1 = (islower(*(++line1)) ? (byte)toupper(*line1) : *line1);
            c2 = (islower(*(++line2)) ? (byte)toupper(*line2) : *line2);
            }
        return(((c1 == c2) ||
                ((isspace(c1) || (c1 == '\0')) &&
                 (isspace(c2) || (c2 == '\0'))))
               ? 0 : 1);
    }
/**/
/********************************************************************
*!name!
*    ged_match_tags()
*!1!
*
*        NAME: ged_match_tags
*
*        DESCRIPTION:
*            Compares the tags of the two nodes.
*
*        RETURN VALUE:
*            Returns 0 if equal, or a non-zero value if not.
*
*        CALLS: ged_get_tag, ged_match
*
*        CALLED BY: ged_inherits
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
int ged_match_tags(node1, node2)
    NODE *node1;
    NODE *node2;
    {			/*!end!*/

        return(ged_match(ged_get_tag(node1), ged_get_tag(node2)));
    }

/**/
/****************************************************************************
*   NAME    ged_matchn(byte *line1, byte *line2, int n)
*
*   DESCRIPTION:    Compares n white space seperated words in line1 to line2
*
*   PARAMETERS:     
*           byte *line1     pointer to string of words
*           byte *line2     pointer to second string of words
*           int  n          number of words to compare
*
*   CALLS:          None
*                   
*
*   RETURN VALUE:  -1
*                   0  Strings matched.
*                   1  Strings match, string 2 is longer, and we are on a
*                      word boundary.
*                   2  Strings match, string 1 is longer, and we are on a
*                      word boundary.
*                   3  String 1 is greater than string 2.
*                   4  String 2 is greater than string 1.
**************************************************************************/
int ged_matchn(byte *line1, byte *line2, int n)
    {                   /*!end!*/
    byte c1;
    byte c2;
    int wasSpace = 0;

    if (!line1 || !line2)
        return(-1);
    c1 = *line1;
    c2 = *line2;
    while ((c1 == c2) && n && (c1 != '\0'))
        {
        c1 = *(++line1);
        c2 = *(++line2);
        if ((isspace(c1) || (c1 == '\0')) && !wasSpace)
            {
            n--;
            wasSpace = 1;
            }
        if (!isspace(c1) && (c1 != '\0'))
            wasSpace = 0;
        }
    if (n)
        {
        if ((c1 != '\0') && (c2 == '\0') && isspace(c1))
            return(2);
        if (c1 > c2)
            return(3);
        if (c2 > c1)
            return(4);
/*printf("1 returning -1<%c><%c>\n", c1, c2);*/
        return(-1);
        }
    if ((c1 == '\0') && (c2 != '\0') && isspace(c2))
        return(1);
    if ((c1 == '\0') && (c2 == '\0'))
        return(0);
    if ((c1 > c2) || (isspace(c1) && (c2 != '\0') && isspace(c2)))
        return(3);
    if (c2 > c1)
        return(4);
/*printf("2 returning -1<%c><%c>\n", c1, c2);*/
    return(-1);
    }

#ifdef NON_ANSI
/******************************************************************************
*!name!
*    ged_strupr()
*!1!
*
*   NAME
*       ged_strupr
*
*   DESCRIPTION
*       The ged_strupr function converts the string str to uppercase.
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
******************************************************************************/
void ged_strupr( str )
    byte *str;
    {			/*!end!*/
         while (*str != '\0')
            {
            *str = toupper( *str );
            str++;
            }
    }

/******************************************************************************
*!name!
*    ged_strrev()
*!1!
*
*   NAME
*       ged_strrev
*
*   DESCRIPTION
*       The ged_strrev function reverses the string str.
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
******************************************************************************/
void ged_strrev( str )
    byte str[];
    {			/*!end!*/
    int c, i, j;

        for (i = 0, j = strlen(str)-1; i < j; i++, j--)
            {
            c = str[i];
            str[i] = str[j];
            str[j] = c;
            }
    }
#endif
