;ͻ
; Script: syschek.sc      Creation Date:01/02/93  Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description:  Displays a pop-up box listing information about the computer  
; system.                                                                     
;                                                                             
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC syscheck.u ()
  PRIVATE systeminfo.y, sysdate.a, directory.a, diskspace.a, checkprinter.n,
  codepool.a, centralmem.a

  DYNARRAY systeminfo.y []

  SYSINFO TO systeminfo.y
  sysdate.a = DOW(TODAY()) + " " + STRVAL(TODAY ())
  directory.a = DIRECTORY ()
  diskspace.a = SUBSTR(FORMAT("w11,ec", DriveSpace(SUBSTR(DIRECTORY(), 1, 1))), 2, 11)
  checkprinter.n = PrinterStatus ()
  codepool.a = FORMAT("w13,ec", RMEMLEFT ())
  centralmem.a = FORMAT("w13,ec", MEMLEFT ())
  systeminfo.y["expanded"] = FORMAT("w13,ec", systeminfo.y["expanded"])
  systeminfo.y["extended"] = FORMAT("w13,ec", systeminfo.y["extended"])

  SWITCH
    CASE systeminfo.y["Language"] = "001":
      systeminfo.y["Language"] = "English"
    CASE systeminfo.y["Language"] = "033":
      systeminfo.y["Language"] = "French"
    CASE systeminfo.y["Language"] = "034":
      systeminfo.y["Language"] = "Spanish"
    CASE systeminfo.y["Language"] = "039":
      systeminfo.y["Language"] = "Italian"
    CASE systeminfo.y["Language"] = "045":
      systeminfo.y["Language"] = "Danish"
    CASE systeminfo.y["Language"] = "046":
      systeminfo.y["Language"] = "Swedish"
    CASE systeminfo.y["Language"] = "049":
      systeminfo.y["Language"] = "German"
  ENDSWITCH


  SHOWDIALOG "System Status"
    @ 3, 10 HEIGHT 16 WIDTH 60

    FRAME SINGLE FROM 1, 1 TO 10, 25       ; Paradox
    FRAME SINGLE FROM 1, 26 TO 7, 57       ; Hardware
    FRAME SINGLE FROM 8, 26 TO 13, 57      ; Memory

    @ 0, 0 ?? FORMAT("w59,ac", directory.a + " --- " + sysdate.a)

    @ 1, 3 ?? " Paradox "
    @ 2, 2 ?? "Version      : " + STRVAL(VERSION ())
    @ 3, 2 ?? "Mouse        : " + IIF(systeminfo.y["Mouse"] = TRUE, "Yes", "No")
    @ 4, 2 ?? "Runtime      : " + IIF(IsRunTime() = TRUE, "Yes", "No")
    @ 5, 2 ?? "Images       : " + STRVAL(NImages())
    @ 6, 2 ?? "Autosave time: " + STRVAL(systeminfo.y["Autosave"]) + " sec."
    @ 7, 2 ?? "Language     : " + systeminfo.y["Language"]
    @ 8, 2 ?? "Sort order   : " + UPPER(SORTORDER ())
    @ 9, 2 ?? "Interface    : " + systeminfo.y["uimode"]

    @ 1, 28 ?? " Hardware "
    @ 2, 27 ?? "Monitor        : " + MONITOR ()
    @ 3, 27 ?? "Screen height  : " + STRVAL(systeminfo.y["screenheight"])
    @ 4, 27 ?? "Screen width   : " + STRVAL(systeminfo.y["screenwidth"])
    @ 5, 27 ?? "Free disk space: " + diskspace.a
    @ 6, 27 ?? "Printer status : " + IIF(PrinterStatus () = TRUE, "Ready", "Not ready")

    @ 8, 28 ?? " Memory Remaining "
    @ 9, 27 ?? "Expanded      : " + systeminfo.y["expanded"]
    @ 10, 27 ?? "Extended      : " + systeminfo.y["extended"]
    @ 11, 27 ?? "Code pool     : " + codepool.a
    @ 12, 27 ?? "Central memory: " + centralmem.a

    PUSHBUTTON
      @ 12, 8 WIDTH 10
      "OK"
      OK
      VALUE "OK"
      TAG "OK"
    TO okvar.a

ENDDIALOG

ENDPROC
WRITELIB libname syscheck.u
RELEASE PROCS syscheck.u
