;ͻ
; Script: postal.sc       Creation Date: 04/04/92 Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: Given an address, the routine will parse the name and correct  
; the it to meet Post Office standards. While it will handle most addresses,  
; it will fail if the street name is also the name of a type of street. For   
; example, 213 Center St. will become 213 Ctr St. Since the routine draws on a
; table for corrections, the user may remove problem names from the list.     
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
; streets                               parse.n                          
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC postal.a(address.a)
  PRIVATE test.n, x, address.a, punct.a, counter.n, newaddress.a

  ARRAY punct.a[2]                     ; an array for punctuation to remove
  punct.a[1] = "."
  punct.a[2] = ","
  FOR x FROM 1 TO 2
  WHILE true                           ; remove commas and periods
    test.n = SEARCH(punct.a[x],address.a)
    IF test.n > 0 THEN
      address.a = SUBSTR(address.a, 1, test.n - 1) + SUBSTR(address.a, test.n + 1, LEN(address.a))
    ELSE
      QUITLOOP
    ENDIF
  ENDWHILE
  ENDFOR

  counter.n = parse.n(address.a, " ")  ; parse the address into separate parts
  IF counter.n = 0 THEN; nothing to parse
    RETURN
  ENDIF

  FOR x FROM 1 TO counter.n
  SWITCH
    CASE x =1:                         ; probably the number
      test.n = ASC(SUBSTR(parse.a[1], x, 1))
      IF test.n < 58 AND test.n > 47 THEN
        parse.a[1] = UPPER(parse.a[1]) ; if so, then upper case for sectionals
      ENDIF
    CASE x =2:                         ; probably the direction
      IF LEN(parse.a[2]) < 3 THEN
        parse.a[2] = UPPER(parse.a[2]) ; two characters is probably NW or the like
      ELSE
        SWITCH
          CASE UPPER(parse.a[2]) = "WEST":  ; examine the single letters
            parse.a[2] = "W"
          CASE UPPER(parse.a[2]) = "EAST":
            parse.a[2] = "E"
          CASE UPPER(parse.a[2]) = "NORTH":
            parse.a[2] = "N"
          CASE UPPER(parse.a[2]) = "SOUTH":
            parse.a[2] = "S"
        ENDSWITCH
      ENDIF
    CASE x =3:                         ;probably the street name
      IF LEN(parse.a[3]) > 2 THEN
        parse.a[3] = SUBSTR(parse.a[3], 1, LEN(parse.a[3]) - 2) + LOWER(SUBSTR(parse.a[3], LEN(parse.a[3]) - 1, 2))
      ENDIF; uppercasing the last two letters
                                       ; for things like 116th St
    OTHERWISE:
      QUITLOOP
  ENDSWITCH
  ENDFOR


  IF counter.n >= 3 THEN; if it's not like 918 Syracuse
    VIEW "streets"
    MOVETO [long]
    FOR x FROM 2 TO counter.n
    LOCATE PATTERN parse.a[x]          ; match against the table
    IF RETVAL THEN
      parse.a[x] = [short]             ; if found, change it
    ENDIF
    ENDFOR
    ClearImage
  ENDIF

  newaddress.a = ""
  FOR x FROM 1 TO counter.n            ; rebuild address
  newaddress.a = newaddress.a + " " + parse.a[x]
  ENDFOR
  RELEASE VARS parse.a                 ; remove array created by parse.n

  RETURN newaddress.a

ENDPROC
WRITELIB libname postal.a
RELEASE PROCS postal.a
