;ͻ
; Script: numbox.sc       Creation Date: 11/24/91 Author: J. Grinstead      
;                         Last Revision: 09/21/92 Revised By: J. Grinstead  
;Ķ
; Description:  Uses a dialog box to prompt the user to enter a number        
;                                                                             
;                                                                             
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                       evenodd.a                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC numbox.n(hed.a)
  PRIVATE choice.n, hed.a, width.n, center.n, okbutton.n, cancelbutton.n,
  result.a

  width.n = LEN(hed.a) + 10                 ; calculating box width
  IF evenodd.a(width.n) = "O" THEN
    width.n = width.n + 1
  ENDIF

  IF width.n < 32 THEN
    width.n = 32                           ; must be at least 32 characters
  ENDIF

  center.n = width.n / 2

  okbutton.n = ROUND((center.n / 2) - 6,0)
  cancelbutton.n = ROUND(center.n + (center.n / 2) - 6,0)


  choice.n = BLANKNUM ()
  SHOWDIALOG hed.a
    @ 8, 40 - center.n
    HEIGHT 7 WIDTH width.n

    ACCEPT @ 1, center.n - 6
      WIDTH 10
      "N"
      TAG "Number"
    TO choice.n

    PUSHBUTTON
      @ 3, okbutton.n
      WIDTH 10
      "~O~K"
      OK
      VALUE "OK"
      TAG "OK"
    TO result.a

    PUSHBUTTON
      @ 3, cancelbutton.n
      WIDTH 10
      "~C~ancel"
      CANCEL
      VALUE "Cancel"
      TAG "Cancel"
    TO result.a
ENDDIALOG

IF NOT RETVAL THEN
  choice.n = "ESC"
ENDIF

RETURN choice.n

ENDPROC
WRITELIB libname numbox.n
RELEASE PROCS numbox.n
