;ͻ
; Script: evenodd.sc      Creation Date: 08/15/92 Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: Returns Accepts a number in either string or numeric format    
; and returns "E" or "O" depending upon whether the number is even or odd. If 
; The value is not entirely numeric, "Error" is returned. The routine will    
; also work for dates.                                                        
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ


PROC evenodd.a(test.v)
  PRIVATE test.v, checkval.a

  checkval.a = SUBSTR(TYPE(test.v),1,1)     ; determine variable type
  SWITCH
    CASE checkval.a = "A":
      test.v = NUMVAL(test.v)
      IF test.v = "Error" THEN           ; must be a letter in with the number
        RETURN test.v
      ENDIF
    CASE checkval.a = "D":
      test.v = FORMAT("d1",test.v)
      test.v = NUMVAL(SUBSTR(test.v,4,2))
    CASE checkval.a <> "N":
      RETURN "Error"                        ; must be other value
  ENDSWITCH

  test.v = STRVAL(test.v)                   ; change to string
  test.v = NUMVAL(SUBSTR(test.v, LEN(test.v), 1))   ; so we can examine last character

  SWITCH; check for even or odd
    CASE test.v = 1
      OR test.v = 3
      OR test.v = 5
      OR test.v = 7
      OR test.v = 9:
      RETURN "O"
    OTHERWISE:
      RETURN "E"
  ENDSWITCH

ENDPROC
WRITELIB libname evenodd.a
RELEASE PROCS evenodd.a
