;ͻ
; Script: errorlog.sc     Creation Date: 3/29/92  Author: J. Grinstead      
;                         Last Revision:10/07/92  Revised By:               
;Ķ
; Description: An errorproc routine that captures system information into a   
; Paradox table and writes variables out to a disk file. The file name is     
; also referenced in the Paradox table.                                       
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
; errorlog                                                               
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC errorlog.u ()
  PRIVATE time.a, user.a, systemmode.a, error.n, errormessage.a,
  directory.a, drivespace.a, privatedirectory.a, scriptdirectory.a,
  numberofimages.n, appmemory.n, codememory.n, tablename.a, numrecords.n,
  currentfield.a, fieldcontents.a, fieldtype.a, numberoffields.n, recordnumber.n,
  formnumber.a, pagenumber.n, canvascol.n, workspacecol.n, canvasrow.n,
  workspacerow.n, menuchoice.a, blankzero.a, emptytable.a, formview.a,
  fieldview.a, runtime.a, messagewindow.a, x, ERRORPROC, varfile.a, errorarray,
  systemarray, script.a, line.n, proc.a, okvar.a, cancelvar.a

  ERRORPROC = ""
  SAVETABLES                                ; protect data -- save to tables

  IF ERRORCODE () = 43 THEN; printer handling code
    SHOWDIALOG "Printer Error"
      @ 8, 18
      HEIGHT 7 WIDTH 44                       ; make it one wider than the text
      @0,1 ?? "          Printer not ready."
      @1,1 ?? "Correct problem and press OK to continue"

      PUSHBUTTON; the OK button
        @ 3, 8 WIDTH 10
        "~O~K"
        OK
        VALUE "OK"
        TAG "OK"
      TO okvar.a

      PUSHBUTTON; the cancel button
        @ 3, 23 WIDTH 10
        "~C~ancel"
        CANCEL
        VALUE "Cancel"
        TAG "Cancel"
      TO cancelvar.a
  ENDDIALOG
ENDIF

SWITCH
  CASE okvar.a = "OK":                 ; successful departure from printer problem
    RETURN 0
  CASE cancelvar.a = "Cancel":
    RETURN 1                           ; continues at next line
ENDSWITCH

SAVEVARS ALL                              ; save variable data
DYNARRAY errorarray []
DYNARRAY systemarray []
DYNARRAY windowarray []
ERRORINFO TO errorarray                   ; get system data into dynarrays
SYSINFO TO systemarray

WHILE TRUE                                ; give savevars file unique name
  varfile.a = STRVAL(ROUND(RAND () * 1000,0)) + ".var"
  IF IsFile(varfile.a) THEN
    LOOP
  ELSE
    RUN norefresh "rename savevars.sc " + varfile.a
    QUITLOOP
  ENDIF
ENDWHILE


time.a = TIME ()                  ; take current conditions and put them in variables
error.n = errorarray["code"]
errormessage.a = errorarray["message"]
script.a = errorarray["script"]
line.n = errorarray["line"]
proc.a = errorarray["proc"]
messagewindow.a = WINDOW ()
user.a = UserName ()
systemmode.a = SYSMODE ()
directory.a = DIRECTORY ()
drivespace.a = DriveSpace(SUBSTR(directory.a,1,1))
privatedirectory.a = PrivDir()
scriptdirectory.a = SDIR ()
numberofimages.n = NImages ()
appmemory.n = MEMLEFT ()
codememory.n = RMEMLEFT ()
extmem.n = systemarray["extended"]
expandmem.n = systemarray["expanded"]

RELEASE VARS errorarray, systemarray      ; free up some memory

IF NImages() = 0 THEN
  tablename.a = "None"
ELSE
  tablename.a = TABLE ()
ENDIF

IF tablename.a = "None" THEN
  numrecords.n = 0
  currentfield.a = ""
  fieldtype.a = ""
  numberoffields.n = 0
  recordnumber.n = 0
  formnumber.a = ""
  pagenumber.n = 0
  canvascol.n = 0
  workspacecol.n = 0
  canvasrow.n = 0
  workspacerow.n = 0
  formview.a = ""
  fieldview.a = ""

ELSE
  numrecords.n = NRecords (tablename.a)
  currentfield.a = FIELD ()
  fieldcontents.a = FieldStr ()
  fieldtype.a = FieldType ()
  numberoffields.n = NFields(TABLE())
  recordnumber.n = RECNO ()
  formnumber.a = FORM ()

  IF IsFormView () THEN
    pagenumber.n = PAGENO ()
    formview.a = "Yes"
  ELSE
    pagenumber.n = 0
    formview.a = "No"
  ENDIF

  canvascol.n = COL ()
  workspacecol.n = COLNO ()
  canvasrow.n = ROW ()
  workspacerow.n = ROWNO ()
ENDIF

menuchoice.a = MENUCHOICE ()

IF menuchoice.a = "Error" THEN              ; no menu on workspace
  menuchoice.a = ""
ENDIF

IF IsBlankZero () THEN
  blankzero.a = "Yes"
ELSE
  blankzero.a = "No"
ENDIF

IF NImages() = 0 THEN
  emptytable.a = "Empty"
  fieldcontents.a = ""
ELSE
  IF IsEmpty (TABLE()) THEN
    emptytable.a = "Yes"
  ELSE
    emptytable.a = "No"
  ENDIF
ENDIF

IF IsFieldView () THEN
  fieldview.a = "Yes"
  CtrlBackspace                             ; avoid lock-up of cursor
  Undo                                      ; return previous data
ELSE
  fieldview.a = "No"
ENDIF

IF IsRunTime () THEN
  runtime.a = "Yes"
ELSE
  runtime.a = "No"
ENDIF

IF SYSMODE () <> "Main" THEN                ; get to main mode for safety
  Do_It!
ENDIF

CLEAR                                  ; conditions recorded, so clear everything out
ClearAll

MESSAGE " Error data recorded "        ; inform user
BEEP BEEP BEEP
SLEEP 1500

MESSAGE " Writing to Errorlog table "  ; inform user
BEEP BEEP BEEP

IF IsTable("Errorlog") THEN; test for error table
  CoEdit "errorlog"
  Ins                                  ; create new record
ELSE
  STYLE ATTRIBUTE 60                   ; major problem if table does not exist
  MESSAGE " MAJOR SYSTEM PROBLEM !!!!! "
  BEEP BEEP BEEP BEEP BEEP BEEP BEEP BEEP BEEP BEEP
  SLEEP 2500
  MESSAGE " Call programmer immediately!! "
  BEEP BEEP BEEP BEEP
  SLEEP 5000
  MESSAGE " You will be returned to DOS in five seconds! "   ; dump user to DOS
  BEEP BEEP BEEP BEEP                                        ; if problem is major
  SLEEP 5000
  EXIT
ENDIF

[date] = TODAY ()                           ; otherwise write the data to the table
[time] = time.a
[error #] = error.n
[error message] = errormessage.a
[message window] = messagewindow.a
[version] = VERSION ()
[user] = user.a
[system mode] = systemmode.a
[monitor type] = MONITOR ()
[directory] = directory.a
[drivespace] = drivespace.a
[private directory] = privatedirectory.a
[script directory] = scriptdirectory.a
[number of images] = numberofimages.n
[application memory] = appmemory.n
[code pool memory] = codememory.n
[table name] = tablename.a
[number of records] = numrecords.n
[current field] = currentfield.a
[field contents] = SUBSTR(fieldcontents.a, 1, 50)
[field type] = fieldtype.a
[fields in table] = numberoffields.n
[record number] = recordnumber.n
[form number] = formnumber.a
[page number] = pagenumber.n
[canvas col] = canvascol.n
[workspace col] = workspacecol.n
[canvas row] = canvasrow.n
[workspace row] = workspacerow.n
[menuchoice] = menuchoice.a
[isblankzero] = blankzero.a
[istableempty] = emptytable.a
[isformview] = formview.a
[isfieldview] = fieldview.a
[variable file] = varfile.a
[script] = script.a
[script line] = line.n
[procedure] = proc.a
[extended memory] = extmem.n
[expanded memory] = expandmem.n

Do_It!

IF runtime.a = "Yes" THEN             ; if runtime, go to DOS,
  EXIT                                ; otherwise go to Paradox
ELSE
  QUIT
ENDIF

ENDPROC
WRITELIB libname errorlog.u
RELEASE PROCS errorlog.u
