;ͻ
; Script: checkptr.sc     Creation Date: 11/07/92 Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: Checks to see if the printer is ready to receive data. If      
; ready, the routine returns true. If not, it displays a dialog box telling   
; the user to fix the problem. The routine will loop until the printer is     
; ready or until ESC or cancel is pressed. In that case, the routine returns  
; false.                                                                      
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC checkprinter.l ()
  PRIVATE calcelvar.a, okvar.a

  WHILE TRUE
    cancelvar.a = ""
    okvar.a = ""
    IF PrinterStatus () THEN
      QUITLOOP
    ELSE
      SHOWDIALOG "Printer Error"
        @ 8, 18
        HEIGHT 7 WIDTH 44                       ; make it one wider than the text
        @0,1 ?? "          Printer not ready."
        @1,1 ?? "Correct problem and press OK to continue"

        PUSHBUTTON; the OK button
          @ 3, 8 WIDTH 10
          "~O~K"
          OK
          VALUE "OK"
          TAG "OK"
        TO okvar.a

        PUSHBUTTON; the cancel button
          @ 3, 23 WIDTH 10
          "~C~ancel"
          CANCEL
          VALUE "Cancel"
          TAG "Cancel"
        TO cancelvar.a
    ENDDIALOG
  ENDIF
  IF cancelvar.a = "Cancel" THEN            ; not allowing ESC to make user
    RETURN FALSE                            ; explicitly cancel printing action
  ELSE
    LOOP
  ENDIF
ENDWHILE

RETURN TRUE

ENDPROC
WRITELIB libname checkprinter.l
RELEASE PROCS checkprinter.l
