;ͻ
; Script: sortaryd.sc     Creation Date: 11/07/92 Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: Sorts an array (not a dynarray) into an decending order.       
;                                                                             
;                                                                             
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC sortarrayd.v (work.r)
  PRIVATE work.r, swapvar.v, change.l

  size.n = ARRAYSIZE (work.r)               ; determine array size

  WHILE TRUE
    change.l = FALSE                        ; initialize change flag
    FOR x FROM 1 TO size.n - 1              ; make sure we don't go higher than
      IF IsAssigned(work.r[x + 1]) THEN     ; declared size
        IF work.r[x] < work.r[x + 1] THEN
          swapvar.v = work.r[x]
          work.r[x] = work.r[x + 1]
          work.r[x + 1] = swapvar.v
          change.l = TRUE                   ; set change flag
        ENDIF
      ELSE
        QUITLOOP
      ENDIF
    ENDFOR
    IF NOT change.l THEN                    ; if no change, then exit
      QUITLOOP
    ENDIF
  ENDWHILE

ENDPROC
WRITELIB libname sortarrayd.v
RELEASE PROCS sortarrayd.v
