;ͻ
; Script: findb.sc        Creation Date: 11/15/92 Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: Searches backwards through a string to find the first occurance
; of a substring. The routine returns the position of the string or zero if   
; it was not found.                                                           
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC findb.n (source.a, find.a, start.n)
  PRIVATE source.a, find.a, x, trips.n, start.n

  find.a = UPPER(find.a)                    ; compare cap strings
  size.n = LEN(find.a)

  IF IsAssigned(start.n) AND start.n > 0 THEN     ; determine where to start
    trips.n = LEN(SUBSTR(source.a, 1, start.n))
  ELSE
    trips.n = LEN(source.a)
  ENDIF

  FOR x FROM trips.n TO 1 STEP -1           ; step backwards through string
    IF find.a = UPPER(SUBSTR(source.a, x, size.n)) THEN
      RETURN x                              ; if found, say where
    ENDIF
  ENDFOR

  RETURN 0                                  ; not found

ENDPROC
WRITELIB libname findb.n
RELEASE PROCS findb.n
