;ͻ
; Script: crawl.sc        Creation Date: 12/29/91 Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: Displays a scrolling message across the bottom of the screen.  
;                                                                             
;                                                                             
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes:  Copyright 1993 Jim Grinstead                                         
;                                                                             
;ͼ

PROC crawl.u (work.a)
  PRIVATE row.n, length.n, work.a, y

  row.n = 24
  length.n = LEN(work.a)
  IF NOT IsAssigned(crawlposition.n) THEN    ; needed on first entry
    crawlposition.n = 79
  ELSE
    crawlposition.n = crawlposition.n - 1    ; increment column position
  ENDIF

  SWITCH
    CASE 80 - crawlposition.n < length.n:    ; if message too long to fit on line
      display.a = SUBSTR(work.a, 1, 80 - crawlposition.n)  ; take as much as can fit
    CASE crawlposition.n = 0:                ; if we're at the beginning of a line
      FOR y FROM 1 TO length.n               ; trim message from left to right
      display.a = SUBSTR(work.a, y, length.n); and print staring at 0
      STYLE ATTRIBUTE 68
      @ row.n, 0
      ?? FILL("", 80)                       ; display line to clear old message

      STYLE ATTRIBUTE 79
      @ row.n, crawlposition.n
      ?? display.a                           ; print partial string
      SLEEP 5                                ; pause a bit to give the user a chance to read
      ENDFOR
      crawlposition.n = 80                   ; reset for next entry into routine
      RETURN
    OTHERWISE:
      display.a = work.a                     ; string will fit, so no problems
  ENDSWITCH

  STYLE ATTRIBUTE 68
  @ row.n, 0                                 ; printing line
  ?? FILL("", 80)

  STYLE ATTRIBUTE 79
  @ row.n, crawlposition.n
  ?? display.a                               ; printing message
  SLEEP 25                                   ; pause so user can read message

ENDPROC
WRITELIB libname crawl.u
RELEASE PROCS crawl.u
