;ͻ
; Script: statusbr.sc     Creation Date: 12/15/91 Author:  J. Grinstead     
;                         Last Revision:          Revised By:               
;Ķ
; Description:  Prints a status bar and message anyplace on the screen.       
; The routine is intended to be used in FOR/NEXT loops and calculates how     
; far through the loop it is. The total length of the bar can be variable.    
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC statusbar.u(msg.a,row.n,col.n, length.n, counter.n,start.n,end.n)
  PRIVATE msg.a, row.n, col.n, counter.n, start.n, end.n, length.n,
  numberofloops.n, pctdone.n, numcols.n

  numberofloops.n = end.n - (start.n - 1)   ; determine the number of loops
  pctdone.n = counter.n / numberofloops.n   ; divide the current position by the total loops for percent
  numcols.n = INT(length.n * pctdone.n)     ; multiply that percent times length to determine bar length

  IF counter.n = start.n THEN
    @ row.n, col.n ?? msg.a
    PaintCanvas ATTRIBUTE 63 row.n, col.n, row.n, col.n + (LEN(msg.a) - 1) ; color the text
    PaintCanvas ATTRIBUTE 76 row.n + 1, col.n + length.n, row.n + 1, col.n + length.n  ; print the end bar
  ENDIF
  PaintCanvas FILL CHR(219) ATTRIBUTE 76 row.n + 1, col.n, row.n + 1, col.n + numcols.n ; print the status bar

ENDPROC
WRITELIB libname statusbar.u
RELEASE PROCS statusbar.u
