;ͻ
; Script: repchar.sc      Creation Date: 11/24/91 Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description:  Searches through a string and replaces all occurances of      
; one character with another.                                                 
;                                                                             
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC replacechar.a(search.a, old.a, new.a)
  PRIVATE search.a, old.a, new.a, ok, left.a, right.a

  WHILE true                          ; looking for matches within the string
    ok = MATCH(search.a, ".." + old.a + "..", left.a, right.a)
    IF ok THEN
      search.a = left.a + new.a + right.a
    ELSE
      QUITLOOP
    ENDIF
  ENDWHILE

  WHILE true                          ; looking for matches at the beginning
    ok = MATCH(search.a, old.a + "..", left.a, right.a)
    IF ok THEN
      search.a = left.a + new.a + right.a
    ELSE
      QUITLOOP
    ENDIF
  ENDWHILE

  WHILE true                          ; looking for matches at the end
    ok = MATCH(search.a, ".." + old.a, left.a, right.a)
    IF ok THEN
      search.a = left.a + new.a + right.a
    ELSE
      QUITLOOP
    ENDIF
  ENDWHILE

  RETURN search.a

ENDPROC
WRITELIB libname replacechar.a
RELEASE PROCS replacechar.a
