;ͻ
; Script: proper          Creation Date: 07/20/92 Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: Routine proper cases a string. For example JOHN JONES becomes  
; John Jones. The only problem with the routine is with strings such as       
; MacDonald which will become Macdonald. If the user has many names like this,
; a simple modification can be made to look up the adjusted phrase in a table 
; and correct it.                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC proper.a(string.a)
  PRIVATE string.a

  string.a = FORMAT("cc",LOWER(string.a))

  IF UPPER(SUBSTR(string.a, 1, 2)) = "MC" OR SUBSTR(string.a, 2, 1) = CHR(39) THEN
    string.a = SUBSTR(string.a, 1, 2) + FORMAT("cc",SUBSTR(string.a, 3, 100))
  ENDIF

  ; to deal with problem strings such as MacDonald, use the locate command
  ; here to look up Macdonald in a table, then change the variable string.a
  ; to the proper wording.

  RETURN string.a

ENDPROC
WRITELIB libname proper.a
RELEASE PROCS proper.a
