;ͻ
; Script: parse.sc        Creation Date: 4/04/92  Author: J. Grinstead      
;                         Last Revision:12/06/92  Revised By:               
;Ķ
; Description: A routine to break a string into pieces using a based on a     
; delimiter. The routine creates an array called parse.a to hold the pieces   
; and returns a number that shows the number of elements in the array. The    
; array is not private, so it is available to other routines as needed.       
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC parse.n(string.a, delimiter.a)
  PRIVATE string.a, delimiter.a, x, elements.n, place.n, counter.n

  elements.n = 0
  place.n = 0
  WHILE TRUE                           ; determine number of elements for array
    place.n = SEARCHFROM(delimiter.a, string.a, place.n + 1)
    IF place.n <> 0 THEN
      elements.n = elements.n + 1
    ELSE                               ; no more elements, so
      elements.n = elements.n + 1      ; add one for final element
      QUITLOOP
    ENDIF
  ENDWHILE

  ARRAY parse.a[elements.n]            ; declare array with sufficient room
  counter.n = 1
  WHILE MATCH(string.a,".." + delimiter.a + "..", left.a, string.a)
    parse.a[counter.n] = left.a        ; loop through string and parse it
    counter.n = counter.n + 1
  ENDWHILE
  parse.a[counter.n] = string.a        ; since no delimiters remain, pick
                                       ; up remainder of string

  RETURN elements.n                    ; return number of elements in array

ENDPROC
WRITELIB libname parse.n
RELEASE PROCS parse.n
