;ͻ
; Script:num2time.sc      Creation Date:01/08/93  Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: Changes a number representing milliseconds since midnight to   
; a standard time format: HH:MM:SS. Particularly useful with the TICKS()      
; function.                                                                   
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC num2time.a(milliseconds.n)
  PRIVATE milliseconds.n, hours.n, minutes.n, seconds.a, hours.a, minutes.a

  milliseconds.n = milliseconds.n / 1000          ; convert to seconds

  hours.n = INT(milliseconds.n / 3600)           ; 3600 seconds per hour
  milliseconds.n = milliseconds.n - (hours.n * 3600) ; remove hours

  minutes.n = INT(milliseconds.n / 60)           ;60 seconds per minute
  milliseconds.n = milliseconds.n - (minutes.n * 60)    ; remove minutes

  seconds.a = STRVAL(milliseconds.n)     ; remainder is seconds
  IF LEN(seconds.a) = 1 THEN; add leading zeros as necessary
    seconds.a = "0" + seconds.a
  ENDIF

  hours.a = STRVAL(hours.n)
  IF LEN(hours.a) = 1 THEN
    hours.a = "0" + hours.a
  ENDIF

  minutes.a = STRVAL(minutes.n)
  IF LEN(minutes.a) = 1 THEN
    minutes.a = "0" + minutes.a
  ENDIF

  RETURN hours.a + ":" + minutes.a + ":" + seconds.a ; return formatted string

ENDPROC
WRITELIB libname num2time.a
RELEASE PROCS num2time.a
