;ͻ
; Script: nth             Creation Date:07/20/92  Author: J. Grinstead      
;                         Last Revision:01/03/93  Revised By:               
;Ķ
; Description: Routine allows the selection of every nth record. This is      
; helpful in selecting a sample of a database. The sample might be a small    
; subset to be used for testing. It may also be useful for marketing where a  
; test is to be done on a portion of a larger group.                          
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;  Although the EXECUTE command can use strings as long as 255 characters, the
; use of the APPENDARRAY command belong will be limited more by memory than   
; by the length of the string. The length was set at 150 to limit the number  
; of records, but may have to be varied depending upon the size of the records
; in your table. If you get "LOW MEMORY WARNING" messages, adjust this number 
; downward to provide you more space to work. See below for the number to     
; adjust.                                                                     
;ͼ

PROC nth_rec.l(spacing.n)
  PRIVATE curtable.a, curdrive.a, spacing.n, sizearray.n, nthrec.r, temp.r

  IF IsFile("nthrec") THEN; get rid of previous versions
    DELETE "nthrec"
  ENDIF

  curtable.a = TABLE ()                ; get name of current table
  curdrive.a = SUBSTR(DIRECTORY(),1,1)

  IF DriveSpace(curdrive.a) < FileSize(curtable.a + ".db") THEN; make sure there's
    hmsgbox.u("Error","Insufficient space on disk drive")         ; room for file
    RETURN FALSE
  ENDIF

  CREATE "nthrec" LIKE curtable.a       ; create table of nth records

  CoEdit "nthrec"

  MOVETO curtable.a
  MOVETO RECORD spacing.n               ; move to first nth record

  counter.n = 1
  arraylist.a = ""
  WHILE TRUE
    newarray.a = "temp" + STRVAL(counter.n)
    newarrayname.a = newarray.a
    IF EOT() THEN
      QUITLOOP
    ELSE
      EXECUTE "CopyToArray " + newarray.a  ; move records to array
    ENDIF

    IF arraylist.a =  "" THEN
      arraylist.a = newarrayname.a
    ELSE
      arraylist.a = arraylist.a + "," + newarrayname.a
      IF LEN(arraylist.a) >= 150 THEN  ; see memory notation above
        MOVETO "nthrec"
        EXECUTE "APPENDARRAY " + arraylist.a
        MOVETO curtable.a
        EXECUTE "RELEASE VARS " + arraylist.a
        arraylist.a = ""
      ENDIF
    ENDIF
    SKIP spacing.n
    counter.n = counter.n + 1
  ENDWHILE

  MOVETO "nthrec"
  EXECUTE "APPENDARRAY " + arraylist.a
  ClearImage
  MOVETO curtable.a


  Do_It!; close edits


  ;-----------------------------------------------------------------------
  ;
  ; The following command can remove the nth records from the original table.
  ; If you want to remove those records, then simply remove the comment
  ; character from the line.
  ;
  ;-----------------------------------------------------------------------

  ; SUBTRACT "nrthrec" curtable.a

  RETURN TRUE                           ; say action was OK

ENDPROC
WRITELIB libname nth_rec.l
RELEASE PROCS nth_rec.l
