;ͻ
; Script: hrs2days.sc     Creation Date: 11/21/92 Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: Takes a time in the HH:MM:SS format and returns the number of  
; days, hours, minutes and seconds it represents. The routine allows for      
; any number of hours. It returns to values in a formatted string which can   
; be easily broken using the MATCH command. See the instruction manual for    
; details.                                                                    
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ


PROC hrs2days.a (timeval.a)
  PRIVATE timeval.a, hours.n, hours.a, days.n, place.n

  place.n = SEARCH(":", timeval.a)
  IF place.n = 0 THEN
    RETURN "0 00:00:00"
  ELSE
    hours.n = NUMVAL(SUBSTR(timeval.a, 1, place.n - 1))
  ENDIF

  IF hours.n < 24 THEN
    RETURN "0 " + timeval.a
  ENDIF

  days.n = 0
  WHILE TRUE
    IF hours.n >= 24 THEN
      days.n = days.n + 1
      hours.n = hours.n - 24
    ELSE
      QUITLOOP
    ENDIF
  ENDWHILE

  IF hours.n < 10 THEN
    hours.a = "0" + STRVAL(hours.n)
    IF SUBSTR(hours.a, 2, 1) = " " THEN
      hours.a = SUBSTR(hours.a, 1, 1) + SUBSTR(hours.a, 3, 1)
    ENDIF
  ELSE
    hours.a = STRVAL(hours.n)
  ENDIF

  RETURN STRVAL(days.n) + " " + hours.a + SUBSTR(timeval.a, place.n, 6)

ENDPROC
WRITELIB libname hrs2days.a
RELEASE PROCS hrs2days.a
