;ͻ
; Script: gettext.sc      Creation Date:11/25/91  Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: Gets a line of text, formats and returns it. Text gotten at    
; current cursor location.                                                    
;                                                                             
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries: PDOX.LIB                                                         
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                       lrtrim.a ()                      
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC gettext.a (length.n, styl.n)
  PRIVATE row.n, col.n, type.a, choice.a, styl.n, length.n

  row.n = ROW ()
  col.n = COL ()
  choice.a = ""

  @ row.n, col.n
  type.a = "A" + STRVAL(length.n)

  ACCEPT type.a TO choice.a

  IF NOT RETVAL THEN
    RETURN "ESC"
  ENDIF

  IF IsBlank (choice.a) THEN
    RETURN false
  ENDIF

  SWITCH
    CASE styl.n = 1:
      choice.a = UPPER(choice.a)
    CASE styl.n = 2:
      choice.a = LOWER(choice.a)
    CASE styl.n = 3:
      choice.a = FORMAT("w"+STRVAL(length.n) + ", CC", choice.a)
  ENDSWITCH

  choice.a = lrtrim.a(choice.a)

  RETURN choice.a

ENDPROC
WRITELIB libname gettext.a
RELEASE PROCS gettext.a
