;ͻ
; Script: getfone2.sc     Creation Date: 11/24/91 Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: A more elegant way of getting a telephone number.              
;                                                                             
;                                                                             
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC getphone2.a ()
  PRIVATE row.n, col.n, fone.a, entry.n, x

row.n = ROW ()                               ; fix current locations
col.n = COL ()

fone.a = ""

@ row.n, col.n ?? "(___) ___-____"              ; print form for user to see

FOR x FROM col.n + 1 TO col.n + 14              ; going one past length to allow for ENTER press to return
@ row.n, x
WHILE true
  entry.n = GETCHAR ()

  SWITCH
    CASE entry.n = 27:                      ; ESC key
      RETURN "ESC"
    CASE entry.n = 8:                       ; Backspace key
      SWITCH
        CASE x = col.n + 6:                         ; handle moving from prefix back to area code
          x = col.n + 2
        CASE x = col.n + 10:                        ; handle moving from suffix to prefix
          x = col.n + 7
        CASE x = col.n:                         ; don't move past beginning of line
          LOOP
        OTHERWISE:                          ; move back. It's two because the loop will increment later
          x = x - 2
      ENDSWITCH
      fone.a = SUBSTR(fone.a, 1, LEN(fone.a) - 1) ; trim off the old number
      QUITLOOP
    case x = col.n + 14:                    ; this allows user to press ENTER
         if entry.n <> 13 then              ; to leave routine at the end
            loop                            ; any other key is rejected
         else
            quitloop                        ; it's ENTER, so bail out
         endif
    CASE entry.n < 48 OR entry.n > 57:      ; not a number, so don't accept
      BEEP
      LOOP
    OTHERWISE:                              ; must be a number, so accept
      ?? CHR(entry.n)
      fone.a = fone.a + CHR(entry.n)        ; add to number list
      QUITLOOP
  ENDSWITCH
ENDWHILE

SWITCH                                      ; moving cursor
  CASE x + 1 = col.n + 4:                   ; past area code into prefix
    x = x + 2
  CASE x + 1 = col.n + 9:                   ; or from prefix to suffix
    x = x + 1
ENDSWITCH

ENDFOR
                                            ;below we format our string of numbers
fone.a = "(" + SUBSTR(fone.a, 1, 3) + ") " + SUBSTR(fone.a, 4,3) + "-" + SUBSTR(fone.a, 7,4)

RETURN fone.a                               ; return the formatted string

ENDPROC
WRITELIB libname getphone2.a
RELEASE PROCS getphone2.a
