*-------------------------------------------------------------------------------
*-- Program...: TRIG.PRG
*-- Programmer: Ken Mayer (CIS: 71333,1030)
*-- Date......: 02/23/1993
*-- Notes.....: Standard trig functions that weren't included in dBASE ...
*--             See the file: README.TXT for details on the use of this library
*--             file.
*-------------------------------------------------------------------------------

FUNCTION Secant
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/01/1992
*-- Notes.......: Secant of an angle X in radians.
*--               Indeterminate and returns error if X is 90 or 270 deg.,
*--                   i.e. mod( abs(X) + pi()/2 , pi() ) = 0
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 03/01/1992 -- Original Release
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: Secant(<nX>)
*-- Example.....: ?Secant(48)
*-- Returns.....: Numeric
*-- Parameters..: nX = Return Secant of X
*-------------------------------------------------------------------------------

	parameters nX
	
RETURN 1 / cos( nX )
*-- EoF: Secant()

FUNCTION CoSecant
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/01/1992
*-- Notes.......: Cosecant of an angle X in radians
*--               Indeterminate and returns error if X = 0 or 180 deg.,
*--                 i. e. mod( abs(X), pi() ) = 0 
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 03/01/1992 -- Original Release
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: CoSecant(<nX>)
*-- Example.....: ?CoSecant(48)
*-- Returns.....: Numeric
*-- Parameters..: nX = Return CoSecant of X
*-------------------------------------------------------------------------------

	parameters nX
	
RETURN 1 / sin( nX )
*-- EoF: CoSecant()

FUNCTION CoTan
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/01/1992
*-- Notes.......: Cotangent of an angle X in radians Indeterminate and returns 
*--               error if X = 0 or 180 deg.,
*--                   i. e. mod( abs(x), pi() ) = 0
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 03/01/1992 -- Original Release
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: CoTan(<nX>)
*-- Example.....: ?CoTan(48)
*-- Returns.....: Numeric
*-- Parameters..: nX = Return CoTan of X
*-------------------------------------------------------------------------------

	parameters nX
	
RETURN  1 / tan( nX )
*-- EoF: CoTan()

FUNCTION ASec
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/01/1992
*-- Notes.......: Inverse secant - angle size in radians for a given
*--               secant value X
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 03/01/1992 -- Original Release
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: ASec(<nX>)
*-- Example.....: ?ASec(48)
*-- Returns.....: Numeric
*-- Parameters..: nX = Return ASec of X
*-------------------------------------------------------------------------------

	parameters nX
	
RETURN acos( 1 / nX )
*-- EoF: ASec()

FUNCTION ACoSec
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/01/1992
*-- Notes.......: Inverse cosecant - angle size in radians for a given
*--               cosecant value X
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 03/01/1992 -- Original Release
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: ACoSec(<nX>)
*-- Example.....: ?ACoSec(48)
*-- Returns.....: Numeric
*-- Parameters..: nX = Return ACoSec of X
*-------------------------------------------------------------------------------

	parameters nX
	
RETURN asin( 1 / nX )
*-- EoF: ACoSec()

FUNCTION ACot
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/01/1992
*-- Notes.......: Inverse cotangent - angle size in radians for a given
*--               cotangent value X
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 03/01/1992 -- Original Release
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: ACoT(<nX>)
*-- Example.....: ?ACoT(48)
*-- Returns.....: Numeric
*-- Parameters..: nX = Return ACoT of X
*-------------------------------------------------------------------------------

	parameters nX
	
RETURN atan( 1 / nX )
*-- EoF: ACoT()

FUNCTION SinH
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/01/1992
*-- Notes.......: Hyperbolic sine of an angle X in radians
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 03/01/1992 -- Original Release
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: SinH(<nX>)
*-- Example.....: ?SinH(48)
*-- Returns.....: Numeric
*-- Parameters..: nX = Return SinH of X
*-------------------------------------------------------------------------------

	parameters nX
	
RETURN ( exp( nX ) - exp( -nX ) ) / 2
*-- EoF: SinH()

FUNCTION CosH
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/01/1992
*-- Notes.......: Hyperbolic cosine of an angle X in radians
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 03/01/1992 -- Original Release
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: CosH(<nX>)
*-- Example.....: ?CosH(48)
*-- Returns.....: Numeric
*-- Parameters..: nX = Return CosH of X
*-------------------------------------------------------------------------------

	parameters nX
	
RETURN ( exp( nX ) + exp( -nX ) ) / 2
*-- EoF: CosH()

FUNCTION TanH
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/01/1992
*-- Notes.......: Hyperbolic tangent of an angle X in radians
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 03/01/1992 -- Original Release
*-- Calls.......: SINH()               Function in TRIG.PRG
*--               COSH()               Function in TRIG.PRG
*-- Called by...: Any
*-- Usage.......: TanH(<nX>)
*-- Example.....: ?TanH(48)
*-- Returns.....: Numeric
*-- Parameters..: nX = Return TanH of X
*-------------------------------------------------------------------------------

	parameters nX

RETURN sinh( nX ) / cosh( nX )
*-- EoF: TanH()

FUNCTION SecH
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/01/1992
*-- Notes.......: Hyperbolic secant of an angle X in radians
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 03/01/1992 -- Original Release
*-- Calls.......: COSH()               Function in TRIG.PRG
*-- Called by...: Any
*-- Usage.......: SecH(<nX>)
*-- Example.....: ?SecH(48)
*-- Returns.....: Numeric
*-- Parameters..: nX = Return SecH of X
*-------------------------------------------------------------------------------

	parameters nX
	
RETURN 1 / cosh( nX )
*-- EoF: SecH()

FUNCTION CScH
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/01/1992
*-- Notes.......: Hyperbolic cosecant of an angle X in radians
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 03/01/1992 -- Original Release
*-- Calls.......: SINH()               Function in TRIG.PRG
*-- Called by...: Any
*-- Usage.......: CScH(<nX>)
*-- Example.....: ?CScH(48)
*-- Returns.....: Numeric
*-- Parameters..: nX = Return CScH of X
*-------------------------------------------------------------------------------

	parameters nX
	
RETURN 1 / sinh( nX )
*-- EoF: CScH()

FUNCTION CoTH
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/01/1992
*-- Notes.......: Hyperbolic cotangent of an angle X in radians
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 03/01/1992 -- Original Release
*-- Calls.......: COSH()               Function in TRIG.PRG
*--               SINH()               Function in TRIG.PRG
*-- Called by...: Any
*-- Usage.......: CoTH(<nX>)
*-- Example.....: ?CoTH(48)
*-- Returns.....: Numeric
*-- Parameters..: nX = Return ACoT of X
*-------------------------------------------------------------------------------

	parameters nX
	
RETURN cosh( nX ) / sinh( nX )
*-- EoF: CoTH()

FUNCTION ASinH
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/01/1992
*-- Notes.......: Inverse hyperbolic sine - angle size in radians
*--               for given hyperbolic sine nX
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 03/01/1992 -- Original Release
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: ASinH(<nX>)
*-- Example.....: ?ASinH(48)
*-- Returns.....: Numeric
*-- Parameters..: nX = Return ASinH of X
*-------------------------------------------------------------------------------

	parameters nX
	
RETURN log( nX + sqrt( nX * nX + 1 ) )
*-- EoF: ASinH()

FUNCTION ACosH
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/01/1992
*-- Notes.......: Inverse hyperbolic cosine - angle size in radians
*--               for given hyperbolic cosine X
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 03/01/1992 -- Original Release
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: ACoSH(<nX>)
*-- Example.....: ?ACoSH(48)
*-- Returns.....: Numeric
*-- Parameters..: nX = Return ACoSH of X
*-------------------------------------------------------------------------------

	parameters nX
	
RETURN log( nX + sqrt( nX * nX - 1 ) )
*-- EoF: ACosH()

FUNCTION ATanH
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/01/1992
*-- Notes.......: Inverse hyperbolic tangent - angle size in radians
*--               for given hyperbolic tangent X
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 03/01/1992 -- Original Release
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: ATanH(<nX>)
*-- Example.....: ?ATanH(48)
*-- Returns.....: Numeric
*-- Parameters..: nX = Return ATanH of X
*-------------------------------------------------------------------------------

	parameters nX
	
RETURN log( ( 1 + nX ) / ( 1 - nX ) ) / 2
*-- EoF: ATanH()

FUNCTION ASecH
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/01/1992
*-- Notes.......: Inverse hyperbolic secant - angle size in radians
*--               for given hyperbolic secant X
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 03/01/1992 -- Original Release
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: ASecH(<nX>)
*-- Example.....: ?ASecH(48)
*-- Returns.....: Numeric
*-- Parameters..: nX = Return ASecH of X
*-------------------------------------------------------------------------------

	parameters nX
	
RETURN log( ( sqrt( -nX * nX + 1 ) + 1 ) / nX )
*-- EoF: ASecH()

FUNCTION ACSCH
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/01/1992
*-- Notes.......: Inverse hyperbolic cosecant - angle size in radians
*--               for given hyperbolic cosecant X
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 03/01/1992 -- Original Release
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: ACSCH(<nX>)
*-- Example.....: ?ACSCH(48)
*-- Returns.....: Numeric
*-- Parameters..: nX = Return ACSCH of X
*-------------------------------------------------------------------------------

	parameters nX
	
RETURN log( ( sign(nX) * sqrt( nX * nX + 1 ) + 1 ) / nX )
*-- EoF: ACSCH()

FUNCTION ACotH
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/01/1992
*-- Notes.......: Inverse hyperbolic cotangent - angle size in radians
*--               for given hyperbolic cotangent X
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 03/01/1992 -- Original Release
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: ACotH(<nX>)
*-- Example.....: ?ACoTH(48)
*-- Returns.....: Numeric
*-- Parameters..: nX = Return ACoTH of X
*-------------------------------------------------------------------------------

	parameters nX
	
RETURN log( ( nX + 1 ) / ( nX - 1 ) ) / 2
*-- EoF: ACotH()

FUNCTION Hav
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/01/1992
*-- Notes.......: Haversine of an angle in radians
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 03/01/1992 -- Original Release
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: Hav(<nX>)
*-- Example.....: ?Hav(48)
*-- Returns.....: Numeric
*-- Parameters..: nX = Return Hav of X
*-------------------------------------------------------------------------------

	parameters nX
	
RETURN ( 1 - cos( nX ) ) / 2
*-- EoF: Hav()

FUNCTION AHav
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/01/1992
*-- Notes.......: Inverse haversine - angle size in radians for given
*--               haversine
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 03/01/1992 -- Original Release
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: AHav(<nX>)
*-- Example.....: ?AHav(48)
*-- Returns.....: Numeric
*-- Parameters..: nX = Return AHav of X
*-------------------------------------------------------------------------------

	parameters nX
	
RETURN acos( 1 - 2 * nX )
*-- EoF: AHav()

*-------------------------------------------------------------------------------
*-- EoP: TRIG.PRG
*-------------------------------------------------------------------------------
