*-------------------------------------------------------------------------------
*-- Program...: HELPROC.PRG
*-- Programmer: Bowen Moursund (CIS: 76566,1405)
*-- Date......: 01/19/1993
*-- Notes.....: This is designed to be a black-box procedure to handle help
*--             screens for the user. See directions in HELPER below. Suggest
*--             using this with SET PROC TO HELPROC or better yet: 
*--                SET LIBR TO HELPROC
*--             This requires the use of HELPER.DBF and HELPER.FMT.
*-------------------------------------------------------------------------------

PROCEDURE Helper
*-------------------------------------------------------------------------------
*-- Programmer..: Bowen Moursund (CIS: 76566,1405)
*-- Date........: 01/19/1993
*-- Notes.......: Helper is a procedure for displaying help text in a full
*--               screen browse. The text is stored in a DBF file:
*--
*--               Structure for database: HELPER.DBF
*--               Field  Field Name  Type       Width    Dec    Index
*--                   1  HELP        Character     78               N
*--
*--               The help text may be loaded into the DBF by creating a
*--               text file using a text editor, and importing the contents
*--               of that file into helper.dbf in this fashion:
*--
*--               . use helper
*--               . zap
*--               . append from <text filename> sdf
*--
*--               Helper is designed to be called as an program interrupt
*--               by the key label F1. Make sure to include the line
*--
*--               on key label F1 do helper
*--
*--               near the beginning of the application. The format file
*--               Helper.fmt must be included with the application.
*--
*-- Written for.: dBASE IV, 1.5
*-- Rev. History: 01/19/1993 -- Original
*-- Calls.......: StrSrch              Procedure in HELPROC.PRG (below)
*--               HELPER.FMT
*--               HELPER.DBF
*-- Called by...: None
*-- Usage.......: on key label F1 do helper
*-- Example.....: see above
*-- Returns.....: Nothing
*-- Parameters..: None
*-- WARNING.....: Do not use this procedure if it might interrupt a dBASE
*--               BEGIN TRANSACTION. Helper opens and closes helper.dbf, and
*--               DBFs cannot be closed while a dBASE transaction is in
*--               progress.
*-------------------------------------------------------------------------------

    on key label F1 ?? ""  && disable interrupt
    private cAlias, cFormat, lTalkOn, lCursOn, lScoreOn, lClockOn, lStatOn, ;
            lLoop, cStr
    lTalkOn = ( set( "talk" ) = "ON" )
    set talk off
    cStr = space(15)  && to be used by search utility
    save screen to sHelpScr
    *-- save environment
    cAlias = alias()
    cFormat = set( "format" )
    lCurson = ( set( "cursor" ) = "ON" )
    lScoreOn = ( set( "scoreboard" ) = "ON" )
    lClockOn = ( set( "clock" ) = "ON" )
    lStatOn = ( set( "status" ) = "ON" )
    lConsOff = ( set( "console" ) = "OFF" )
    lPrintOn = ( set( "printer" ) = "ON" )
    lFieldsOn = ( set( "fields" ) = "ON" )

    set printer off
    set console on
    set fields off

    define window wHelper from 0,0 to 23,79 none
    select select()
    use helper
    set format to helper
    set clock off
    set cursor off
    set scoreboard off
    lLoop = .t.
    if lStaton
        set status off
    endif
    on key label F1 do strsrch
    activate window wHelper
    do while lLoop
        lLoop = .f.  && procedure strsrch might set this .t.
        browse noappend noclear nomenu noedit nodelete compress format
    enddo
    deactivate window wHelper
    on key label F1 ?? ""
    use

    *-- restore environment
    if lScoreOn
        set scoreboard on
    endif
    if lCurson
        set cursor on
    endif
    if lClockOn
        set clock on
    endif
    if "" # cAlias
        select ( cAlias )
    endif
    if "" # cFormat
        set format to ( cFormat )
    endif
    if lStatOn
        set status on
    endif
    if lConsOff
        set console off
    endif
    if lPrintOn
         set printer on
    endif
    if lFieldsOn
        set fields on
    endif
    if lTalkOn
        set talk on
    endif

    release window wHelper
    restore screen from sHelpScr
    release screen sHelpScr
    on key label F1 do helper

RETURN
*-- EoP: Helper

PROCEDURE StrSrch
*-------------------------------------------------------------------------------
*-- Programmer..: Bowen Moursund (CIS: 76566,1405)
*-- Date........: 01/19/1993
*-- Notes.......: String search procedure for PROCEDURE Helper
*-- Written for.: dBASE IV, 1.5
*-- Rev. History: 01/19/1993 -- Original
*-- Calls.......: None
*-- Called by...: Helper               Procedure in HELPROC.PRG (above)
*-- Usage.......: Do StrSrch
*-- Example.....: See above
*-- Returns.....: None
*-- Parameters..: None
*-------------------------------------------------------------------------------

    on key label F1 ?? ""  && disable interrupt
    private cTrimStr, cSearchStr, lSearchLoop
    close format  && gotta close format because of the search string read
    lSearchLoop = .t.
    define window wStrSrch from 15,19 to 21,59
    define window w_Shadow from 16,17 to 22,57 none color n/n,n/n
    activate window w_Shadow
    activate window wStrSrch
    @1,10 say "HELP Search Utility"

    do while lSearchLoop
        @3,0
        *-- cStr initialized in procedure helper
        @3,4 say "Search string " + chr(16) get cStr function "!" ;
         message "Enter search string.    Esc: Cancel"
        set cursor on
        read
        set cursor off
        cTrimStr = ltrim( rtrim( cStr ) )
        if lastkey() # 27 .and. "" # cTrimStr
            nRecNo = recno()
            cSearchStr = upper( cTrimStr )
            lFound = .f.
            if .not. eof()
                * look for next occurrence of cSearchStr
                do while .not. eof() .and. .not. lFound
                    skip
                    lFound = ( cSearchStr $ upper( help ) )
                enddo
            endif
            if .not. lFound
                @3,0
                ?? chr(7)
                @3,20 - (len(cTrimStr+" not found.")/2) say cTrimStr + ;
                  " not found."
                i = inkey(3)
                goto nRecNo
                lSearchLoop = .t.
            else
                *-- lLoop initialized in procedure helper
                lLoop = .t.  && re-browse after terminating
                lSearchLoop = .f.
                keyboard chr(23)  && terminate the browse
            endif
        else
            lSearchLoop = .f.  && exit the loop
        endif
    enddo

    deactivate window wStrSrch
    deactivate window w_Shadow
    release window wStrSrch
    release window w_Shadow
    set format to helper
    on key label F1 do strsrch

RETURN
*-- EoP: StrSrch

*-------------------------------------------------------------------------------
*-- End of Program: HELPROC.PRG
*-------------------------------------------------------------------------------
