/*

  Program......:  TEST.PRG
  Purpose......:  Example of enhanced COPY FILE command.  Requires FCOPY.CH
                  header file and FCOPY.PRG file.  Also requires a TEST.DBF
                  of any size to be used for copying.  This file can be
                  created with the DBCRE8.EXE utility that comes with the
                  SIx Driver and/or HiPer-SIx RDDs.
  Author.......:  Loren Scott, SuccessWare 90, Inc. - (909)699-9657
  Last Update..:  11/02/93

  Compile......:  CLIPPER test /w
  Link.........:  BLINKER FI test,fcopy LI clipper

  Syntax.......:  COPY FILE <old> TO <new>          ;
                    [OPTION <opt> [STEP <step>]]    ;
                    [BUFFER <buf>]

                  Where:  <old>  = Name of source file to be copied.
                          <new>  = Name of destination file to be created.
                          <opt>  = Optional function to be executed for
                                   every <step> buffer fulls of data copied.
                          <step> = Optional number of full buffers to copy
                                   before calling the <opt> function.  The
                                   default is 1 (for every buffer full).
                          <buf>  = Optional buffer size, in kilobytes, to
                                   use for reading/writing the files.  The
                                   default is 8k, as defined in FCOPY.CH.

*/


#include "Box.ch"

#include "fCopy.ch"  // Header file to support extended COPY FILE syntax

LOCAL nStart := 0

clear screen
IF !file( "TEST.DBF" )
  Alert( "Requires a TEST.DBF to use for copying!")
  QUIT
ENDIF


? "Standard CLIPPER.........:"
nStart := Seconds()
__CopyFile( "test.dbf", "test2.dbf" )   // Call standard COPY FILE function
?? Seconds() - nStart

? "DEFAULT (8k Buffer)......:"
nStart := Seconds()
COPY FILE test.dbf TO test2.dbf
?? Seconds() - nStart

? "4k BUFFER................:"
nStart := Seconds()
COPY FILE test.dbf TO test2.dbf BUFFER 4
?? Seconds() - nStart

? "16k BUFFER...............:"
nStart := Seconds()
COPY FILE test.dbf TO test2.dbf BUFFER 16
?? Seconds() - nStart

? "32k BUFFER...............:"
nStart := Seconds()
COPY FILE test.dbf TO test2.dbf BUFFER 32
?? Seconds() - nStart

? "OPTION...................:"
nStart := Seconds()
COPY FILE test.dbf TO test2.dbf OPTION MyUDF()
?? Seconds() - nStart

? "OPTION, STEP 5...........:"
nStart := Seconds()
COPY FILE test.dbf TO test2.dbf OPTION MyUDF() STEP 5
?? Seconds() - nStart

? "OPTION, BUFFER 16........:"
nStart := Seconds()
COPY FILE test.dbf TO test2.dbf OPTION Meter() BUFFER 16
?? Seconds() - nStart

? "OPTION, STEP 5, BUFFER 16:"
nStart := Seconds()
COPY FILE test.dbf TO test2.dbf OPTION MyUDF() STEP 5 BUFFER 4
?? Seconds() - nStart
?


//-----------------------------------------------------------------------//
// Calls _CopyBytes() and _CopyPct() from FCOPY.PRG

FUNC MyUDF()

LOCAL nRow := row(), nCol := col()

@ nRow,47 say "Bytes: " + AllTrim( Str( _CopyBytes() ))
@ nRow,65 say "Pct %: " + AllTrim( Str( _CopyPct() ))

DevPos( nRow, nCol )

IF inkey() == 27
  Return(.F.)
ENDIF

Return( .T. )


//-----------------------------------------------------------------------//
// Calls _CopyBytes(), _CopySize, and _CopyPct() from FCOPY.PRG

FUNC Meter()

LOCAL nRow := MaxRow()/2, nCol := 15, nPctDone := _CopyPct()
LOCAl nOldRow := Row(), nOldCol := Col()
STATIC cScreen := ""

IF empty( cScreen )
  cScreen := SaveScreen( nRow-2, nCol-2, nRow+3, nCol+53 )
  DispBox( nRow-2, nCol-1, nRow+3, nCol+53, B_DOUBLE + " " )
ENDIF

@ nRow-1, nCol+1 SAY Replicate(" ", ((nPctDone-.5) / 2) -2) +;
                     Str(nPctDone,3)+"%"
@ nRow, nCol+1 SAY Replicate("", ((nPctDone-.5) / 2)) + "" +;
                   Replicate("", ( 50  - (nPctDone / 2)))

@ nRow+2, nCol+1 SAY "Bytes Copied: " + AllTrim( Str( _CopyBytes() )) +;
                     " / " + AllTrim( Str( _CopySize()))

IF nPctDone == 100
  @ nRow-1, nCol+1 SAY Replicate(" ",47) + "100%"
  @ nRow, nCol+1 SAY Replicate("", 50)
  inkey(1)
  RestScreen( nRow-2, nCol-2, nRow+3, nCol+53, cScreen )
  cScreen := ""
ENDIF

DevPos( nOldRow, nOldCol )

IF inkey() == 27
  RestScreen( nRow-2, nCol-2, nRow+3, nCol+53, cScreen )
  cScreen := ""
  Return(.F.)
ENDIF

Return(.T.)



