/*
 * SQL.H - Header file for Orion SQL Application Programming Interface
 *
 * LANGUAGE      : Microsoft C6.0
 * MODEL         : N/A
 * ENVIRONMENT   : Microsoft Windows 3.0
 *
 * Developed by:
 *   Philip Roll
 *   Ming-Li Wang
 *
 * (C) Copyright 1991
 * Stellar Industries
 * 3335 S. Falcon Ridge Road
 * Diamond Bar  CA 91765
 * (714) 861-7885
 *
 */

/*
 *
 * Data classes:
 *
 */

#define mSqlDataClassAPPROXIMATE        0
#define mSqlDataClassBINARY             1
#define mSqlDataClassCHAR               2
#define mSqlDataClassEXACT              3
#define mSqlDataClassINVALID            4

/*
 *
 * Data types:
 *
 */

#define mSqlDataTypeBINARY              0
#define mSqlDataTypeCHAR                1
#define mSqlDataTypeDECIMAL             2
#define mSqlDataTypeDOUBLE              3
#define mSqlDataTypeFLOAT               4
#define mSqlDataTypeINTEGER             5
#define mSqlDataTypeNUMERIC             6
#define mSqlDataTypeREAL                7
#define mSqlDataTypeSMALLINT            8
#define mSqlDataTypeVARCHAR             9
#define mSqlDataTypeINVALID             10

/*
 *
 * Error codes:
 *
 */

#define mSqlErrorAmbiguousColumn        1
#define mSqlErrorBadEnvironment         2
#define mSqlErrorBinaryNotAllowed       3
#define mSqlErrorCannotActivateFile     4
#define mSqlErrorCannotCloseFile        5
#define mSqlErrorCannotCloseLog         6
#define mSqlErrorCannotCreateDataFile   7
#define mSqlErrorCannotCreateDumpFile   8
#define mSqlErrorCannotCreateFile       9
#define mSqlErrorCannotCreateKeyFile    10
#define mSqlErrorCannotCreateLog        11
#define mSqlErrorCannotDeleteFile       12
#define mSqlErrorCannotDropTable        13
#define mSqlErrorCannotOpenDataFile     14
#define mSqlErrorCannotOpenFile         15
#define mSqlErrorCannotOpenKeyFile      16
#define mSqlErrorCannotOpenLog          17
#define mSqlErrorCannotRemoveTable      18
#define mSqlErrorCharNotAllowed         19
#define mSqlErrorCheckpointDetected     20
#define mSqlErrorDataFileCorrupted      21
#define mSqlErrorDatabaseCorrupt        22
#define mSqlErrorDbaNotAvailable        23
#define mSqlErrorDivideByZero           24
#define mSqlErrorDuplicateColumn        25
#define mSqlErrorDuplicateRecord        26
#define mSqlErrorExistingDataFile       27
#define mSqlErrorExistingKeyFile        28
#define mSqlErrorFileReadFailed         29
#define mSqlErrorFileSeekFailed         30
#define mSqlErrorFileWriteFailed        31
#define mSqlErrorGlobalLockFailed       32
#define mSqlErrorGlobalUnlockFailed     33
#define mSqlErrorImportParseError       34
#define mSqlErrorIncompatibleTypes      35
#define mSqlErrorIndexExists            36
#define mSqlErrorIndexUndoFailed        37
#define mSqlErrorInitializationFailed   38
#define mSqlErrorInsufficientBuffer     39
#define mSqlErrorInternalError          40
#define mSqlErrorInvalidColumnSpec      41
#define mSqlErrorInvalidColumnType      42
#define mSqlErrorInvalidCursor          43
#define mSqlErrorInvalidData            44
#define mSqlErrorInvalidEscapeChar      45
#define mSqlErrorInvalidPattern         46
#define mSqlErrorInvalidTableID         47
#define mSqlErrorInvalidUser            48
#define mSqlErrorKeyFileCorrupted       49
#define mSqlErrorListSizesUnequal       50
#define mSqlErrorMultipleSelects        51
#define mSqlErrorNoColumnExists         52
#define mSqlErrorNoIndexExists          53
#define mSqlErrorNoOldRecord            54
#define mSqlErrorNoTableExists          55
#define mSqlErrorNoUserExists           56
#define mSqlErrorNodeSizeTooSmall       57
#define mSqlErrorNotAggregate           58
#define mSqlErrorNotGroupingColumn      59
#define mSqlErrorNotInGroupedTable      60
#define mSqlErrorNotSingleRecord        61
#define mSqlErrorNullInNotNullCol       62
#define mSqlErrorNullNotAllowed         63
#define mSqlErrorParserSyntaxError      64
#define mSqlErrorParserStackOverflow    65
#define mSqlErrorPrecisionConflict      66
#define mSqlErrorResultTableExists      67
#define mSqlErrorScaleOverflow          68
#define mSqlErrorSecurityViolation      69
#define mSqlErrorSetFunctionsNested     70
#define mSqlErrorStarNotAllowed         71
#define mSqlErrorSubqueryNotOneColumn   72
#define mSqlErrorTableConflict          73
#define mSqlErrorTableExists            74
#define mSqlErrorTooManyColumnNames     75
#define mSqlErrorTooManyTablesOpen      76
#define mSqlErrorTrialSizeExceeded      77
#define mSqlErrorVariableHeaderMark     78
#define mSqlErrorVariableHeaderSize     79
#define mSqlErrorVariableHeaderWrong    80
#define mSqlErrorVariableHeaderZero     81
#define mSqlErrorWrongVersion           82

/*
 *
 * Record structure formats:
 *
 */

#define mSqlFlagFormatPadded            0x0000
#define mSqlFlagFormatString            0x0001
#define mSqlFlagFormatStructure         0x0002

/*
 *
 * Auto commit options:
 *
 */

#define mSqlFlagAutoCommitOnLogout      0x0010

/*
 *
 * Maximum number of significant characters in named entity:
 *
 */

#define mSqlMaximumNameLength           32

/*
 *
 * Global types:
 *
 */

typedef struct tagSQLCOLUMN {
  BOOL            bRightJustified;
  char            szColumnHeading[mSqlMaximumNameLength + 1];
  unsigned        nColumnSequenceNumber;
  unsigned        nDataClass;
  unsigned        nDataType;
  unsigned        nFieldWidth;
  unsigned        nPrecision;
  unsigned        nScale;
}               SQLCOLUMN;
typedef SQLCOLUMN *PSQLCOLUMN;
typedef SQLCOLUMN far *LPSQLCOLUMN;

typedef struct tagSQLCONTROL {
  char            szErrorDetail[65];
  char            szErrorMessage[257];
  unsigned        nHiLiteLength;
  unsigned        nHiLiteOffset;
  unsigned        nPadding;
  unsigned        nRecordBufferSize;
  unsigned        nResultCode;
  unsigned long   lRecordPosition;
  unsigned long   lReserved0;
  unsigned long   lReserved1;
  unsigned long   lReserved2;
  unsigned long   lReserved3;
  unsigned long   lReserved4;
  WORD            wFlags;
}               SQLCONTROL;
typedef SQLCONTROL *PSQLCONTROL;
typedef SQLCONTROL far *LPSQLCONTROL;

typedef struct tagSQLSTATUS {
  unsigned long   lNumberOfRecordDeletes;
  unsigned long   lNumberOfRecordInserts;
  unsigned long   lNumberOfRecordSelects;
  unsigned long   lNumberOfRecordUpdates;
  unsigned long   lTimeElapsed;
}               SQLSTATUS;
typedef SQLSTATUS *PSQLSTATUS;
typedef SQLSTATUS far *LPSQLSTATUS;

typedef struct tagSQLTABLE {
  unsigned        nNumberOfColumns;
  unsigned        nRecordSize;
  unsigned long   lNumberOfRecords;
}               SQLTABLE;
typedef SQLTABLE *PSQLTABLE;
typedef SQLTABLE far *LPSQLTABLE;

/*
 *
 * Function prototypes:
 *
 */

BOOL FAR PASCAL SqlCursorClose(HANDLE, HANDLE, LPSQLCONTROL);
HANDLE FAR PASCAL SqlCursorOpen(HANDLE, LPSQLCONTROL);
BOOL FAR PASCAL SqlDescribeColumn(HANDLE, HANDLE, LPSQLCONTROL, unsigned, LPSQLCOLUMN);
BOOL FAR PASCAL SqlDescribeTable(HANDLE, HANDLE, LPSQLCONTROL, LPSQLTABLE);
BOOL FAR PASCAL SqlExecute(HANDLE, HANDLE, LPSQLCONTROL, LPSTR);
BOOL FAR PASCAL SqlFetchFirst(HANDLE, HANDLE, LPSQLCONTROL, LPSTR);
BOOL FAR PASCAL SqlFetchLast(HANDLE, HANDLE, LPSQLCONTROL, LPSTR);
BOOL FAR PASCAL SqlFetchNext(HANDLE, HANDLE, LPSQLCONTROL, LPSTR);
BOOL FAR PASCAL SqlFetchPositioned(HANDLE, HANDLE, LPSQLCONTROL, unsigned long, LPSTR);
BOOL FAR PASCAL SqlFetchPrevious(HANDLE, HANDLE, LPSQLCONTROL, LPSTR);
BOOL FAR PASCAL SqlGetStatus(HANDLE, HANDLE, LPSQLCONTROL, LPSQLSTATUS);
HANDLE FAR PASCAL SqlLogin(LPSQLCONTROL, LPSTR, LPSTR);
BOOL FAR PASCAL SqlLogout(HANDLE, LPSQLCONTROL);
