/*[]------------------------------------------------------------[]*/
/*|                                                              |*/
/*|     Source code for TDVIDEO.DLL (for TDW.EXE)                |*/
/*|                                                              |*/
/*|     Main module - to be used with card spacific submodules   |*/
/*|                                                              |*/
/*|                                                              |*/
/*|     Copyright (c) 1991 by Borland International              |*/
/*|     All Rights Reserved.                                     |*/
/*|                                                              |*/
/*[]------------------------------------------------------------[]*/

/* Written by Jeffrey J. Peters */

/*
   The target of these files is {mfg}.DLL which gets renamed to TDVIDEO.DLL
   There are always two files that are used.  The main (video.c) file
   contains all the general logic and entrypoints that TDW calls.  It
   also gets all the .INI file options and sets all the flags.  It
   allocates any memory that is needed, and then calls a function
   (CheckVideo) in the card spacific module ({mfg}.c).

   Video.c     - All .DLL entry points, and general logic and init code
   {mfg}.c     - Card spacific code (ATI, TSENG, Paradise, Trident,...)
*/

#include <windows.h>   // cause we're in Windows
#include <dos.h>       // for geninterrupt()
#include <stdio.h>     // for fprintf()
#include "tdvideo.h"   // prototypes for our TDW/TDVIDEO API

void far pascal FatalAppExit (int, char far *); // in case we need to barf

#define mono(a) {if (debug_string) fprintf (debug_file, "\n%s",a);} // cause I'm lazy

char card_ident[] = "TDW video driver for CoExistance with CornerStone";

void SetVideoMode (BYTE m);
void RestoreVgaArea (void);
void SaveVgaArea (void);
void error (int);

#define BIOS              0x10     // for BIOS interrupt calls

// #define fclose(a) close (dup (fileno(a)))   // only for debugging
// #define force(a) close (dup (fileno(a)))    // only for debugging
#define force(a)   // null macro

// #define dll_check() {if (!dll_in_use) FatalAppExit (0, fatal_error);}
#define dll_check() {if (!dll_in_use) exit (-99);}
char far *fatal_error = "Fatal TDVIDEO.DLL Error";

WORD oldmode = 0;           // word to save video mode before switching it
WORD newmode = 0;           // normal textmode for TDW (3 = 80x25 text)
int vmode = -1;             // inital video mode detected
int tsize = 25;             // number of lines per screen
int tscreen = 0;            // 0 for color screen, 1 for mono
unsigned int MaxBytesPerPage = 0x8000;  // default # of bytes to save
int maxplanes = 3;          // number of planes to save
int savepalette = 1;        // 1 = save the palette, 0 = don't
int screen = 0;             // 1 = save whole screen, 0 = only 3 planes
int ignoremode = 0;         // 1 = ignore video mode/card checking (undocumented)
int int2fassist = 0;        // 1 = use VM 2Fh calls, 0 = don't use 2F
                            //     these are documented in the MSC DDK
int oem = 0;                // 1 = call enable/disable, 0 = just 2F stuff
                            //     these are documented in the MSC DDK
int disable_video = 0;      // 1 = disable video when accessing video memory (not used any more)
static int debug_string = 0;// 1 = write helpful info to a debugging file
                            //     specified with DebugFile= in the .INI
                            // 0 = don't log anything
static int dll_in_use = 1;  // sanity check; 1 = we should be called, 0 = fatal error

FILE *debug_file;           // FILE* for the debugging file (if any)
BYTE palette[256][3];       // for saving the 256 color palette
BYTE BUF[2048];             // memory for fp_enable
v_buf_t v_buf;              // structure for holding the plane data pointers

FARPROC fp_enable, fp_disable; // used with IgnoreMode

//--------------------------------------------------------------------------//
#pragma argsused
int FAR PASCAL LibMain( HANDLE hInstance, WORD wDataSegment,
                        WORD wHeapSize, LPSTR lpszCmdLine )
/*
   This is a standard Windows DLL LibMain function.
*/
{
 // The startup code for the DLL initializes the local heap (if there is one)
 // with a call to LocalInit which locks the data segment.
    if ( wHeapSize != 0 )
        UnlockData( 0 );

    return 1;   // Always succeed LibMain
}
//--------------------------------------------------------------------------//
#pragma argsused
int FAR PASCAL WEP ( int bSystemExit )
/*
   This is a standard Windows DLL WEP function.
*/
{

    return 1;  // Unload succeeded
}
//--------------------------------------------------------------------------//
WORD _win VideoInit (void)
/*
   This function detects the video card and mode and allocates the
   memory for the memory saving routines.
*/
{
  char buf[81];
  char drv_dll[61];
  int z,j;
  struct time tm;
  struct date da;

  v_on()

  GetPrivateProfileString ("VideoOptions", "DebugFile",
                           "NUL", buf, 80, "TDVIDEO.INI");

  if (!lstrcmp (buf, "NUL"))
    debug_string = 0;
  else
    debug_string = 1;

  if (debug_string)
  {
    if ((debug_file = fopen (buf,"wt")) == NULL)
      debug_string = 0;

    getdate (&da);
    gettime (&tm);
    fprintf(debug_file,"\nLogging on %02d/%02d/%04d at %2d:%02d\n",
            da.da_mon, da.da_day, da.da_year,
            tm.ti_hour, tm.ti_min);

    fprintf (debug_file, "\n%s (Built on %s, %s)\n"
    "------------------------------------------------"
    "------------------------------",
    card_ident,__DATE__,
    __TIME__); mono ("TDVIDEO.DLL:VideoInit"); }

  GetPrivateProfileString ("VideoOptions", "SaveWholeScreen", "0", buf,
                           10, "TDVIDEO.INI");

  strupr (buf); if (buf[0] == 'Y' || buf[0] == '1') screen = 1; else
  screen = 0;

  GetPrivateProfileString ("VideoOptions", "DisableVideo",
                            "0", buf, 10, "TDVIDEO.INI");

  strupr (buf);
  if (buf[0] == 'Y' || buf[0] == '1')
    disable_video = 1;
  else
    disable_video = 0;

  disable_video = 0;     // doesn't work now

  GetPrivateProfileString ("VideoOptions", "Int2FAssist", "0", buf,
                           10, "TDVIDEO.INI");
  strupr (buf); int2fassist = (buf[0] == 'Y' || buf[0] == '1')? 1:0;

  GetPrivateProfileString ("VideoOptions", "IgnoreMode", "0", buf,
                           10, "TDVIDEO.INI");
  strupr (buf); ignoremode = (buf[0] == 'Y' || buf[0] == '1')? 1:0;

  GetPrivateProfileString ("boot", "display.drv", "NULL",
                           drv_dll, 60, "SYSTEM.INI");

  if (drv_dll[0] == 0)
  {
    if (debug_string)
    {
      fprintf (debug_file, "\n  WARNING: Unable to locate 'display.drv' "
                           "in SYSTEM.INI\n");

      if (ignoremode)
        fprintf (debug_file, "\n           IgnoreMode is now 0");
      ignoremode = 0;
    }
  }
  else
  {
     fp_enable =  GetProcAddress (GetModuleHandle(drv_dll),
                                  "Enable");
     fp_disable = GetProcAddress (GetModuleHandle(drv_dll),
                                 "Disable");
  }


  if (debug_string)
    fprintf (debug_file, "\n  display.drv=%s", drv_dll);

  newmode = 3;  // Normal text mode (80x25)
  dll_in_use = 1;
  return 0;  // 0 = success
}
//--------------------------------------------------------------------------//
WORD _win VideoDone (void)
/*
   This function frees all the memory allocated for saving data.
*/
{
  int j;


  dll_check ();      // make sure that we are supposed to be called
  v_off()

  return 1;
}
//--------------------------------------------------------------------------//
WORD _win VideoIsColor (void)
/*
   This function is called to determine if we are in color or mono mode.
*/
{
  dll_check ();      // make sure that we are supposed to be called

  return !tscreen;     // color mode
}

//--------------------------------------------------------------------------//
WORD _win VideoGetTextSelector (int display)
/*
   This function returns the protected mode selector that corrisponds to
   the real mode segment of the text screen requested.  display will be
   0 for the primary display or 1 for the secondary display.  We cann
   assume that in TDW, primary is color (B800) and secondary is
   monochrome (B000).  If we want to fail the secondary screen, we
   return 0
*/
{
  dll_check ();      // make sure that we are supposed to be called
  return ( ((WORD) &_B800H) );
}
//--------------------------------------------------------------------------//
void _win VideoSetCursor (WORD x, WORD y)
/*
   This function positions the cursor on the text mode screen.
*/
{
  WORD a, port = 0x3D4;  // color port

  dll_check ();      // make sure that we are supposed to be called

  a = y * 80 + x;
  outportb (port, 0x0E); // cursor location high byte reg.
  _CX = a;
  outport (port+1, _CH);
  outportb (port, 0x0F); // cursor location low byte reg.
  _CX = a;
  outport (port+1, _CL);
}

//--------------------------------------------------------------------------//
void _win VideoDebuggerScreen (void)
/*
   This function saves the palette and video memory, and switches into
   text mode.
*/

{
  dll_check ();      // make sure that we are supposed to be called
  SetVideoMode (newmode);
}
//--------------------------------------------------------------------------//
void _win VideoWindowsScreen (void)
/*
   This function switches back into graphics mode, restoring the
   palette, and video memory.
*/

{
  dll_check ();      // make sure that we are supposed to be called
}
//--------------------------------------------------------------------------//
WORD _win VideoBigSize (void)
/*
   This function returns the maximum number of lines that the high res
   text mode can handle (usually 43 or 50).
*/
{
  int size = 60;

  dll_check ();      // make sure that we are supposed to be called
  return size;
}
//--------------------------------------------------------------------------//
void _win VideoSetSize (WORD bigflag)
/*
   This function changes the text mode to (bigflag==1) 50 line mode, or
   (bigflag==0), 25 line mode.
*/

{
  dll_check ();      // make sure that we are supposed to be called
  if (bigflag)
  {
      tsize = 60;

      _AX = 0x0026;
      geninterrupt (0x10);

#if 0
      _AX = 0x1112;               /* load 8x8 character set */
      _BX = 0;
      geninterrupt (0x10);

      _AX = 0x0112;
      _CX = 0x0600;
      geninterrupt (0x10);
#endif

  }
  else
  {
    _AX = 0x0083;     // 80x25 color text mode and don't clear screen
    geninterrupt (BIOS);
    tsize = 25;
  }
}
//--------------------------------------------------------------------------//
void SaveVgaArea (void)
/*
   This function saves the VGA palette
*/
{
}
//--------------------------------------------------------------------------//
void RestoreVgaArea (void)
/*
   This function restores the VGA palette
*/
{
}
//--------------------------------------------------------------------------//
void error (int a)
{
  WORD j,k;

  return;
  for (k=0;k<a;k++)
  {
    MessageBeep (0);
    for (j=0;j<0xFFF0;j++)
      _AL+=6, _AL+=6;  // waste time
  }
}

//--------------------------------------------------------------------------//
void SetVideoMode (BYTE m)
/*
   This function sets a particular video mode via BIOS.  Some SuperVGA
   modes cannot be entered via BIOS and require direct register
   manipulation.  NOTE: you need to set the high bit of the mode to tell
   BIOS not to clear the screen when switching modes.  If you don't do
   this you will have to save the ENTIRE graphics screen (250k - 1000k)!
*/
{
  if ((m == 3) && (tsize != 25))
  {
    _AX = 0x0083;
    geninterrupt (0x10);
    VideoSetSize (1);
    return;
  }

  _AH = 0x00;
  _AL = m;
  if (screen != 1)
    asm or al, 0x80;   // don't clear screen
  geninterrupt (BIOS);
}
