/*[]------------------------------------------------------------[]*/
/*|                                                              |*/
/*|     Source code for TDVIDEO.DLL (for TDW.EXE)                |*/
/*|                                                              |*/
/*|     For the TSENG ET-3000 & ET-4000 chip sets                |*/
/*|     (256 color modes only)                                   |*/
/*|                                                              |*/
/*|     Copyright (c) 1991 by Borland International              |*/
/*|     All Rights Reserved.                                     |*/
/*|                                                              |*/
/*[]------------------------------------------------------------[]*/


/* Written by Jeffrey J. Peters */

#include <windows.h>
#include <dos.h>       // for geninterrupt()
#include "tdvideo.h"

char card_ident[] = "TDW video driver for TSENG ET-3000/ET-4000 256 color";

WORD GetVideoMode (void);
void SetVideoMode (BYTE m);
void SaveTextArea (void);
void RestoreTextArea (void);

int _3or4 (void);   // 1 if ET-4000, 0 if ET-3000
int is4 = 0;

WORD port = 0x01CE;

#define BIOS     0x10     // for BIOS interrupt calls
#define TSENG    0x3CD    // Port address for segment select register

int bits = 256;                 // 16, or 256
BYTE palette16[0x15];             // for 16 color palette table

//--------------------------------------------------------------------------//
int CheckVideoInfo (void)
/*
   This function is only called from VIDEO.C and is used to check for
   video mode/card specifics.  Use this function to check for the proper
   card (if needed) or the video modes that are supported.
*/
{
  WORD m;

  is4 = _3or4 ();

  m = GetVideoMode ();     // get current video mode
  m = m & ~0x80;           // strip off high bit.

  if (m < 0x13)
    return 0;      // tell VideoInit that TDW will be handling the swapping

  switch (m)
  {
    case 0x2D:
    case 0x2E:
    case 0x2F:
    case 0x30:
    case 0x38:
                bits = 256;
                return 1;
    case 0x25:
    case 0x27:
    case 0x29:
                return -1;      // not implemented yet
                MaxBytesPerPage = 0xFFFF;
                maxplanes = 3;
                bits = 16;
                return 2;

    case 0x37:
                return -1;

    default:
                return -1;
  }
  return 0;     // never gets here
}
//--------------------------------------------------------------------------//
WORD GetVideoMode (void)
/*
   This function gets the current video mode from BIOS.  NOTE: some
   SuperVGA modes cannot be entered from BIOS and may not update the
   BIOS data area to reflect the proper mode number.
*/
{
   _AH = 0x0F;
   geninterrupt (BIOS);
   return _AL;
}
//--------------------------------------------------------------------------//
void SetVideoMode (BYTE m)
/*
   This function sets a particular video mode via BIOS.  Some SuperVGA
   modes cannot be entered via BIOS and require direct register
   manipulation.  NOTE: you need to set the high bit of the mode to tell
   BIOS not to clear the screen when switching modes.  If you don't do
   this you will have to save the ENTIRE graphics screen (250k - 1000k)!
*/
{
  if ((m == 3) && (tsize != 25))
  {
    _AX = 0x0083;
    geninterrupt (0x10);
    VideoSetSize (1);
    return;
  }

  _AH = 0x00;
  _AL = m;
  if (screen != 1)
    asm or al, 0x80;   // don't clear screen
  geninterrupt (BIOS);
}
//--------------------------------------------------------------------------//

void SaveTextArea (void)
/*
   This function saves the video memory that will get blown away by
   entering text mode.
*/
{
  WORD i, j;
  WORD plane_hold;
  char far *p;
  LPSTR q;

  p = MK_FP ((WORD)&_A000H, 0);

  plane_hold = inportb (TSENG);  // save old value of segment select

  for (j=0;j<maxplanes;j++)
  {
    if (is4)
      outportb (TSENG, (j<<4)); // select read plane
    else
      outportb (TSENG, 0x40 | (j<<3)); // select read plane

    q = GlobalLock (v_buf.hplane[j]);
    for (i=0;i<MaxBytesPerPage;i++)
    {
      q[i] = p[i];
    }
    GlobalUnlock (v_buf.hplane[j]);
  }
  outport (TSENG, plane_hold); // reset to old value

}

void RestoreTextArea (void)
/*
   This function restores the video memory that gets blown away by going
   into text mode.  For this mode it's plane 0, 1, and 2.
*/
{
  WORD i, j,k;
  WORD plane_hold;
  char far *p;
  LPSTR q;

  p = MK_FP ((WORD)&_A000H, 0);

  plane_hold = inportb (TSENG);  // save old value


  for (j=0;j<maxplanes;j++)
  {
    if (is4)
      outportb (TSENG, j); // select write plane
    else
      outportb (TSENG, 0x40 | j); // select write plane

    q = GlobalLock (v_buf.hplane[j]);
    for (i=0;i<MaxBytesPerPage;i++)
    {
      p[i] = q[i];
    }
    GlobalUnlock (v_buf.hplane[j]);
  }
  outport (TSENG,plane_hold); // reset to old value
}

int _3or4 (void)
{
  asm {
    mov dx, 03C5h
    in al, dx
    mov ah, al
    mov al, 33h
    out dx, al

    inc dx
    in al, dx

    push ax
    dec al
    out dx, al
    mov bl, al
    in al, dx
    cmp al, bl
    jne fail
    mov cx, 1
    jmp done
  }
  fail:

  asm mov cx, 0

  done:
  asm {
    pop ax
    out dx, al
    dec dx
    mov al, ah
    out dx, al
  }
  return _CL;
}

