/*[]------------------------------------------------------------[]*/
/*|                                                              |*/
/*|     Source code header for TDVIDEO.DLL (for TDW.EXE)         |*/
/*|                                                              |*/
/*|     Generic TDW API for all chip sets and modes              |*/
/*|                                                              |*/
/*|     Copyright (c) 1991 by Borland International              |*/
/*|     All Rights Reserved.                                     |*/
/*|                                                              |*/
/*[]------------------------------------------------------------[]*/

/* Written by Jeffrey J. Peters */
#include <stdio.h>     // for fprintf and FILE


// _win is a macro NOT a keyword
#define _win far pascal _export

/*
   This is a list of prototypes for the functions that must be supported
   for TDW.  You can have one DLL for every video mode mode or one DLL
   for every chip set, saving the screen data differently for the
   various modes.
*/

WORD       _win VideoInit            (void);
/*
   Called when TDW first loads up.  All dynamic allocation and chip and
   video mode detection should be preformed here.
   Return codes are:

    0 - success
    1 - Incorrect video card was detected
    2 - Unsupported video mode of correct card was detected
    3 - Could not allocate the memory needed from Windows
    4 - Regular video mode detected (TDVIDEO.DLL not required)
    5 - Misc. error

   Any failure will cause TDW to unload TDVIDEO.DLL.
*/

WORD       _win VideoDone            (void);
/*
   Called when TDW exits back to Windows.  All memory allocated must be
   freed by the end of this function (Don't rely on libmain and WEP).
   1 means success, 0 means it failed.
*/

WORD       _win VideoGetTextSelector (int display);
/*
   Called when TDW needs the selector (protected mode segment) value of
   the text mode screen requested.  If display is 0, you need to return
   the selector for the address 0xB800 (color). If display is 1, you
   need to return the selector for the address 0xB000 (mono).  This can
   be done with the Windows pre-defined selectors: _B800H and _B000H.
   In 'C' you need to take its address after it is externed properly.
*/

void       _win VideoSetCursor       (WORD x, WORD y);
/*
   Called when TDW needs to set the cursor position on the text mode
   screen.  Most VGA cards can use the code that we provide (since it's
   a non SuperVga register that controls the cursor position).  TDW will
   call this function when it needs to make the cursor disappear (by
   placing it at a non-displayable position).
*/

void       _win VideoDebuggerScreen  (void);
/*
   Called when TDW wants to switch to the text mode screen.  This
   function must save the appropriate memory locations, save the VGA
   palette, and switch to text mode.
*/

void       _win VideoWindowsScreen   (void);
/*
   Called when TDW wants to switch back to the Windows screen.  This
   function must switch back to the original graphics mode, restore the
   palette, and restore the SuperVGA graphics memory planes that were
   blown away by text mode.  (This will usually be 4 to 8 K in planes 0
   and 1 [for the text mode characters and attributes], and 32K in plane
   2 [for the character generator data]).
*/

WORD       _win VideoBigSize         (void);
/*
   Called when TDW needs to determine if there is a higher resolution
   text mode availible (usually 43 or 50 lines).  The maximum number of
   lines that this you are able to support should be returned here.
*/

void       _win VideoSetSize         (WORD bigflag);
/*
   Called when TDW wants to switch the resolution of the text mode
   screen.  Bigflag will be 1 if high res, 0 if low res.
*/

WORD       _win VideoIsColor (void);
/*
   Returns 1 for color, and 0 for monochrome;
*/

#define v_off() {_AX = 0x1201; _BL = 0x36; geninterrupt (0x10);}
#define v_on()  {_AX = 0x1200; _BL = 0x36; geninterrupt (0x10);}
/*
   v_off() and v_on()  are macros to turn off and on the video screen
   to allow maximum through-put when saving and restoring the video screen
*/


int CheckVideoInfo (void);  // checks for and sets up card spacific
                            // information.

extern char card_ident[];
extern WORD _B800H;  // text mode screen segment (color)
extern WORD _B000H;  // mono text segment
extern WORD _C000H;  // video rom segment
extern WORD _A000H;  // graphics mode screen segment

extern WORD oldmode;
extern WORD newmode;
extern int tsize;
extern int tscreen;
extern int vmode;
extern unsigned int MaxBytesPerPage;
extern int maxplanes;
extern int screen;
extern int savepalette;
extern int disable_video;
extern int debug_string;
extern FILE *debug_file;

typedef struct
{
  HANDLE hplane[16];
}v_buf_t;

extern v_buf_t v_buf;

