/*                                                                       */
/*    This header file contains four configurable directives:            */
/*                                                                       */
/*      1.  OS Environment - DOS, OS/2, or Windows                       */
/*      2.  C Compiler - WatCom, Microsoft, Turbo C                      */
/*      3.  API Level Support                                            */
/*      4.  Memory Model for Embedded SQL applications                   */
/*                                                                       */
/*    Choose one directive from each set to define the correct           */
/*    compiler configuration.                                            */
/*                                                                       */

#ifndef __intf_defined
  #define  __intf_defined

/*-----------------------------------------------------------------------*/
/*                                                                       */
/*     1.  OS Environment                                                */
/*         Define OS enviroment for correct selection of                 */
/*         NetWare SQL API prototypes.                                   */
/*                                                                       */
/*        Choose one of the following by removing the comment markers    */
/*        for the environment you are compiling for.  Then add           */
/*        comment markers for the other directives.  If you use          */
/*        only one of the environments, you may choose to delete the     */
/*        other directives in this section.                              */
/*                                                                       */
#define NWSQL_DOSENV
/*#define NWSQL_OS2ENV               */
/*#define NWSQL_WINENV               */

/*-----------------------------------------------------------------------*/
/*                                                                       */
/*     2.  C Compiler                                                    */
/*         Define the compiler by removing the comment markers for the   */
/*         compiler of your choice, and adding comment markers for the   */
/*         others.                                                       */
/*                                                                       */

#define WATCOM
/*#define MSC                        */
/*#define TURBOC                     */

/*-----------------------------------------------------------------------*/
/*                                                                       */
/*     3.  API Level Support                                             */
/*         By default, this interface includes support for both API      */
/*         levels.  To disable support for one API level, add comment    */
/*         markers around the API level you are not using.  If you       */
/*         always use only one API level, you may choose to delete       */
/*         the unnecessary directive.                                    */
/*                                                                       */

#define  _NWSQL_SQL_FUNCTIONS
#define  _NWSQL_RELATIONAL_PRIMITIVES

/*-----------------------------------------------------------------------*/
/*                                                                       */
/*     4.  Memory Model                                                  */
/*         This directive is used by the Embedded SQL precomiler only.   */
/*         If your embedded SQL application is compiled for the          */
/*         COMPACT, LARGE, or HUGE memory model, remove the comments     */
/*         around this directive.                                        */
/*                                                                       */
/*                                                                       */
/*#define LMODEL                     */

#endif

