
/*
 * Copyright (c) 1991 Darryl Collins.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Darryl Collins, University of western Australia.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */


/*
 * Please send questions, comments and bug-reports to
 *
 *               darryl@fibula.surgery.uwa.oz.au
 *
 * Sources to the DLL are available upon request.
 */

/* #include "windows.h" */

#define NB_WAIT           0x00                  /*  Wait for completion          */
#define NB_NOWAIT         0x80         /*  Do no wait for completion*/

#define NB_RESET          0x32         /*  Reset adapter                         */
#define NB_CANCEL         0x35         /*  Cancel command                        */
#define NB_ASTATUS        0x33         /*  Get NETBIOS intf status       */
#define NB_UNLINK         0x70         /*  Unlink   (RPL)                        */

#define NB_ADDNAME        0x30         /*  Add name                              */
#define NB_ADDGROUP       0x36         /*  Add group name                        */
#define NB_DELNAME        0x31         /*  Delete name                           */

#define NB_CALL           0x10         /*  Call                                  */
#define NB_LISTEN         0x11         /*  Listen                                        */
#define NB_HANGUP         0x12         /*  Hang up                                       */
#define NB_SEND           0x14         /*  Send                                  */
#define NB_SENDNACK       0x71         /*  Send                                  */
#define NB_CHSEND         0x17         /*  Chain send                            */
#define NB_CHSENDNACK     0x72         /*  Chain send                            */
#define NB_RECEIVE        0x15         /*  Receive                                       */
#define NB_RECANY         0x16         /*  Receive any                           */
#define NB_SESSTATUS      0x34         /*  Get session status            */

#define NB_SDATAGRAM      0x20         /*  Send datagram                         */
#define NB_SBROADCAST     0x22         /*  Send broadcast                        */
#define NB_RDATAGRAM      0x21         /*  Receive datagram              */
#define NB_RBROADCAST     0x23         /*  Receive broadcast             */

struct Ncb;

typedef struct Ncb      NCB;
typedef HANDLE          HNCB;
typedef NCB far *       LPNCB;

struct Ncb {

	unsigned char   NcbCommand;
	unsigned char   NcbRetCode;
	unsigned char   NcbLsn;
	unsigned char   NcbNum;

	LPSTR                   NcbBuffer;
	unsigned int    NcbLength;

	char                    NcbCallName[16];
	char                    NcbName[16];

	unsigned char   NcbRto;
	unsigned char   NcbSto;

	FARPROC                 NcbPostRoutine;

	unsigned char   NcbLanaNum;
	unsigned char   NcbCmdCmplt;

	char                    NcbReservedArea[14];

	HWND                    hWnd;
	HANDLE                  hNcb;

	LPNCB                   lpNext;
	LPNCB                   lpPrev;
};

extern LPNCB            lpNcbList;

typedef struct {
	unsigned char           bssNameNum;
	unsigned char           bssNumSessions;
	unsigned char           bssPendingRecDataGram;
	unsigned char           bssPendingRecAny;
} BASESESSIONSTATUS;

typedef struct {
	unsigned char           ssLsn;
	unsigned char           ssState;
	char                            ssLocalName[16];
	char                            ssRemoteName[16];
	unsigned char           ssPendingReceives;
	unsigned char           ssPendingSends;
} SESSIONSTATE;

typedef struct {
	BASESESSIONSTATUS       bss;
	SESSIONSTATE            ss[10];
} SESSIONSTATUS;

typedef struct {
	char    szNodeName[6];
	char    cMajorVersion;
	char    cReserved;
	char    cAdapterType;
	char    cMinorVersion;
	int             nReportPeriod;
	int             nReceiveReject;
	int             nTransmitReject;
	int             nReceiveError;
	int             nTransmitAbort;
	long    lTransmitCount;
	long    lReceiveCount;
	int             nTransmitError;
	int             nRemoteDepletion;
	int             nExpiredT1;
	int             nExpiredTi;
	LPSTR   lpExtStatus;
	int             nFreeCmdBlks;
	int             nMaxPendingNCBs;
	int             nMaxCommands;
	int             nTransmitDepletion;
	int             nMaxPacketSize;
	int             nPendingSessions;
	int             nMaxPendingSessions;
	int             nMaxSessions;
	int             nMaxSessionPacketSize;
	int             nNameTableEntries;
} ADAPTERSTATUS;


LPNCB FAR PASCAL Reset(HWND hWnd,unsigned char nLsn, unsigned char nNum);
LPNCB FAR PASCAL AdapterStatus(HWND hWnd,LPSTR lpCallName, LPSTR lpStatBuf, unsigned nLength, BOOL bWait);
LPNCB FAR PASCAL Cancel(HWND hWnd,LPNCB lpNcb);
LPNCB FAR PASCAL Unlink(HWND hWnd);

LPNCB FAR PASCAL AddName(HWND hWnd,LPSTR lpName, BOOL bWait);
LPNCB FAR PASCAL DeleteName(HWND hWnd,LPSTR lpName, BOOL bWait);
LPNCB FAR PASCAL AddGroupName(HWND hWnd,LPSTR lpName, BOOL bWait);

LPNCB FAR PASCAL Call(HWND hWnd,LPSTR lpCallName, LPSTR lpName, BOOL bWait);
LPNCB FAR PASCAL Listen(HWND hWnd,LPSTR lpCallName, LPSTR lpName, BOOL bWait);
LPNCB FAR PASCAL HangUp(HWND hWnd,unsigned char nLsn, BOOL bWait);
LPNCB FAR PASCAL Send(HWND hWnd,unsigned char nLsn, LPSTR lpBuffer, unsigned nLength, BOOL bWait);
LPNCB FAR PASCAL Receive(HWND hWnd,unsigned char nLsn, LPSTR lpBuffer, unsigned nLength, BOOL bWait);
LPNCB FAR PASCAL ReceiveAny(HWND hWnd,unsigned char nNum, LPSTR lpBuffer, unsigned nLength, BOOL bWait);
LPNCB FAR PASCAL ChainSend(HWND hWnd,unsigned char nLsn, LPSTR lpBuf0, unsigned nLength0, LPSTR lpBuf1, unsigned nLength1, BOOL bWait);
LPNCB FAR PASCAL SessionStatus(HWND hWnd,LPSTR lpBuffer, unsigned nLength, LPSTR lpName, BOOL bWait);
LPNCB FAR PASCAL SendNoAck(HWND hWnd,unsigned char nLsn, LPSTR lpBuffer, unsigned nLength, BOOL bWait);
LPNCB FAR PASCAL ChainSendNoAck(HWND hWnd,unsigned char nLsn, LPSTR lpBuf0, unsigned nLength0, LPSTR lpBuf1, unsigned nLength1, BOOL bWait);

LPNCB FAR PASCAL SendDatagram(HWND hWnd,unsigned char nNum, LPSTR lpBuffer, unsigned nLength, LPSTR lpCallName, BOOL bWait);
LPNCB FAR PASCAL ReceiveDatagram(HWND hWnd,unsigned char nNum, LPSTR lpBuffer, unsigned nLength, BOOL bWait);
LPNCB FAR PASCAL SendBroadcastDatagram(HWND hWnd,unsigned char nNum, LPSTR lpBuffer, unsigned nLength, BOOL bWait);
LPNCB FAR PASCAL ReceiveBroadcastDatagram(HWND hWnd,unsigned char nNum, LPSTR lpBuffer, unsigned nLength, BOOL bWait);

void FAR PASCAL  ReleaseNcb(LPNCB lpNcb);
LPSTR FAR PASCAL AllocFixedBuffer(unsigned int);
void FAR PASCAL  FreeFixedBuffer(LPSTR);



#define NB_COMMAND      0xdcdc
