/***************************************************************************
 *  NAMESRV.H								   *
 *	This file contains following NetBIOS Name Service related function *
 *	prototypes:
 *									   *
 *	  AddName  () - Adds a unique name or group name in the Name Table *
 *	  DelName  () - Deletes a name from the Name Table		   *
 *	  FindName () - Find a name on the networks			   *
 *									   *
 *  History:	Alok Sinha  October, 1991    Created			   *
 *									   *
 ***********************************************************************/

#ifndef NAMESRV_INCLUDED
#define NAMESRV_INCLUDED

unsigned char	AddName ( char *pchName ,
			  unsigned char ucFlag,
			  unsigned char ucLana,
			  unsigned char *pucNameNum
			);

unsigned char	DelName ( char *pchName ,
			  unsigned char ucLana,
			  unsigned char ucNameNum
			);
BOOL FindName		( char *pchName,
			  unsigned char ucLana
			);


/*
 * AddName Attribute Values
 */
#define   ADD_UNIQUE_NAME   1
#define   ADD_GROUP_NAME    2

#endif /* NAMESRV_INCLUDED */
