// This is a sample for Post Routine code for DOS ncb

#define FALSE 0
#define TRUE  1

#include <stdio.h>
#include <dos.h>
#include <string.h>

#include <netcons.h>
#include <ncb.h>
#include <netbios.h>
#include "astat.h"

void NetBiosRequest(NCB far *);


struct sstat {
    unsigned char  ss_namenum;
    unsigned char  ss_numsess;
    unsigned char  ss_numrdgm;
    unsigned char  ss_numrany;
    struct ss_sess ss_struct[1];
    };

//post Routine

extern void  cdecl interrupt far  PostRoutine(
			    unsigned int es, unsigned int ds,
			    unsigned int di, unsigned int si,
			    unsigned int bp, unsigned int sp,
			    unsigned int bx, unsigned int dx,
			    unsigned int cx, unsigned int ax,
			    unsigned int ip, unsigned int cs,
			    unsigned int flags);



// Boolean signal between main and PostRoutine

int  PostRoutineDriven;

void main()
{
    NCB tstNCB;
    ASTAT AStatBuf;
    register int i,j;
    unsigned short *usPtr;

    // assign a pointer to PostRoutine
    void  (far *PostRoutinePtr)() = (void (far *)()) PostRoutine;

		    // ADD A NAME

    tstNCB.ncb_command = NCBADDNAME | ASYNCH;
    strcpy(tstNCB.ncb_name,"aa");
    tstNCB.ncb_lana_num = 0;

    usPtr = (unsigned short *) &tstNCB.ncb_post;
    *usPtr  = FP_OFF( PostRoutinePtr);
    usPtr++;
    *usPtr  = FP_SEG( PostRoutinePtr);


    printf("submitting NCBADDNAME   ");
    NetBiosRequest((NCB far *)&tstNCB);
    do {

	    // We will come out once Post Routine is done

    }while (PostRoutineDriven == FALSE );
    PostRoutineDriven = FALSE;

    printf("cmd cplt code: %d\n",tstNCB.ncb_cmd_cplt);
    printf("ret code: %d\n",tstNCB.ncb_retcode);

		// NOW DELETE NAME

    tstNCB.ncb_command = NCBDELNAME | ASYNCH;
    strcpy(tstNCB.ncb_name,"aa");
    tstNCB.ncb_lana_num = 0;

    usPtr = (unsigned short *) &tstNCB.ncb_post;
    *usPtr  = FP_OFF( PostRoutinePtr);
    usPtr++;
    *usPtr  = FP_SEG( PostRoutinePtr);



    printf("submitting NCBDELNAME   ");
    NetBiosRequest((NCB far *)&tstNCB);
    do {

	    // We will come out once Post Routine is done

    }while (PostRoutineDriven == FALSE );
    PostRoutineDriven = FALSE;

    printf("cmd cplt code: %d\n",tstNCB.ncb_cmd_cplt);
    printf("ret code: %d\n",tstNCB.ncb_retcode);



		// ADD A GROUP NAME

    tstNCB.ncb_command = NCBADDGRNAME | ASYNCH;
    strcpy(tstNCB.ncb_name,"aa");
    tstNCB.ncb_lana_num = 0;

    usPtr = (unsigned short *) &tstNCB.ncb_post;
    *usPtr  = FP_OFF( PostRoutinePtr);
    usPtr++;
    *usPtr  = FP_SEG( PostRoutinePtr);



    printf("submitting NCBADDGRNAME   ");
    NetBiosRequest((NCB far *)&tstNCB);
    do {

	    // We will come out once Post Routine is done

    }while (PostRoutineDriven == FALSE );
    PostRoutineDriven = FALSE;

    printf("cmd cplt code: %d\n",tstNCB.ncb_cmd_cplt);
    printf("ret code: %d\n",tstNCB.ncb_retcode);


		// NOW DELETE GROUP NAME

    tstNCB.ncb_command = NCBDELNAME | ASYNCH;
    strcpy(tstNCB.ncb_name,"aa");
    tstNCB.ncb_lana_num = 0;

    usPtr = (unsigned short *) &tstNCB.ncb_post;
    *usPtr  = FP_OFF( PostRoutinePtr);
    usPtr++;
    *usPtr  = FP_SEG( PostRoutinePtr);



    printf("submitting NCBDELNAME   ");
    NetBiosRequest((NCB far *)&tstNCB);
    do {

	    // We will come out once Post Routine is done

    }while (PostRoutineDriven == FALSE );
    PostRoutineDriven = FALSE;

    printf("cmd cplt code: %d\n",tstNCB.ncb_cmd_cplt);
    printf("ret code: %d\n",tstNCB.ncb_retcode);


		// ADAPTOR STATUS

    tstNCB.ncb_command = NCBASTAT;
    tstNCB.ncb_buffer = (char far *)&AStatBuf;
    tstNCB.ncb_length = sizeof(ASTAT);
    strcpy(tstNCB.ncb_callname,"*");
    tstNCB.ncb_lana_num = 0;

    printf("submitting NCBASTAT     ");
    NetBiosRequest((NCB far *)&tstNCB);
    printf("ret code: %d\n",tstNCB.ncb_retcode);

    printf("-- names in adapter --\n");
    for(i=0;i<AStatBuf.as_names;i++)  {
	for(j=0;j<NCBNAMSZ;j++)
	    if (AStatBuf.as_struct[i].as_name[j] != 0)
		printf("%c",AStatBuf.as_struct[i].as_name[j]);
	    else  {
		for(;j<NCBNAMSZ;j++) printf(" ");
		break;
		}
	printf("   %3d",AStatBuf.as_struct[i].as_number);
	printf("   %4x\n",AStatBuf.as_struct[i].as_status);
	}
    printf("----------------------\n");


    printf("\n All is well!!!\n");


}

void NetBiosRequest(NcbPtr)
NCB *NcbPtr;
{
    union REGS InRegs,OutRegs;
    struct SREGS SegRegs;

    InRegs.x.bx = FP_OFF(NcbPtr);
    SegRegs.es	= FP_SEG(NcbPtr);

    int86x(0x5C,&InRegs,&OutRegs,&SegRegs);
}






void  cdecl interrupt far  PostRoutine(
				 es,	  ds,
				 di,	  si,
				 bp,	  sp,
				 bx,	  dx,
				 cx,	  ax,
				 ip,	  cs,
				 flags)
  unsigned es, ds, di, si, bp, sp, bx, dx, cx, ax, ip, cs, flags;
  {

    PostRoutineDriven = TRUE;
   /* NO DOS CALLS ALLOWED HERE SINCE DOS IS NON-REENTRANT*/

    // ES:BX point to completed ncb

}
