/***************************************************************************
 *  TTy2.C								   *
 *	This file shows the usage of NetBIOS session commands.		   *
 *	The program must be run two machines who wish to communicate.	   *
 *	In this sample program, one side must receive packets while the	   *
 *	while the other side sends packets. They can of course change	   *
 *	their roles. The program, of course, is not very user friendly	   *
 *	and can be improved by implementing asynchronous send and receives.*
 *	This will give user the ability to receive and send  at the	   *
 *	same  time.							   *
 *									   *
 *	It is possible for receiver side to not name the remote person.    *
 *	is illustrated by second usage line under LISTENER below	   *
 * Sample Usage:							   *
 *	Machine TALKER		    Machine LISTENER			   *
 *	--------------		    ----------------			   *
 *	 c:>TTy2 talker listener    c:>TTy2 listener talker		   *
 *				    c:>TTy2 talker
 *									   *
 *  History:   Alok Sinha  October, 1991    Created			   *
 *									   *
 **************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>

#include <common.h>
#include <namesrv.h>
#include <session.h>


#define  LINE_SIZE 80
#define  SEND	   1
#define  RECEIVE   2
#define  LISTEN    3
#define  CALL	   4
#define  ESC	   0x1B
#define  NEWLINE   0x0D
#define  _EOF_	   0x1A
#define  SEND_TIME_OUT	  ((unsigned char) 120)
#define  RECEIVE_TIME_OUT ((unsigned char) 120)

void CopyToBuffer ( char *pchDest , char *pchSrc);
BOOL CallListen   ( unsigned char ucLana, char *pchRemoteNameBuffer,
		    char *pchLocalNameBuffer, unsigned char far *ucLsn);
void SendReceive  ( unsigned char ucLsn, unsigned char ucLana,
		    char *pchRemoteNameBuffer);
int  GetLine	  ( char *pchBuffer);

int main ( int argc, char **argv)
{

    char chLocalNameBuffer  [ NCBNAMSZ ];
    char chRemoteNameBuffer [ NCBNAMSZ ];
    unsigned char   ucLana;
    unsigned char   ucLsn;
    unsigned char   ucNameNum;
    unsigned char   ucRc;


    if (argc < 2 )
    {
	printf ("Usage: TTy2 <local name> <remote name> [<lana>]\n");
	exit (1);

    }
    CopyToBuffer( chLocalNameBuffer, argv[1]);
    if (argc == 2)
	CopyToBuffer( chRemoteNameBuffer, "*");
    else if (argc >= 3)
	CopyToBuffer( chRemoteNameBuffer, argv[2]);

    printf("Local Name:  [%16.16s]\n", chLocalNameBuffer);

    printf("Remote Name: [%16.16s]\n", chRemoteNameBuffer);

    /* What is the LAN Adaptor number */
    if (argc >= 4)
	ucLana = (unsigned  char ) atoi ( argv [3] );
    else
	ucLana = 0;
    printf ( "LANA: [%d] \n",	 ucLana);

    /* Initialize in case of OS/2 */
    NetInit( ucLana);

    /* Add a Name */
    ucRc =     AddName ( chLocalNameBuffer,
			 ADD_UNIQUE_NAME,
			 ucLana,
			 &ucNameNum
		       );

    printf("AddName:: RC: [%x] NameNumber: [%x]\n", ucRc, ucNameNum);

    if (ucRc )
	return NetCleanUp (1);

    /*
     * Make a connection. Only if connection is successful, send and
     * receive data.
     */
    if (CallListen( ucLana, chRemoteNameBuffer, chLocalNameBuffer, &ucLsn)
	== TRUE)
    {
	SendReceive ( ucLsn, ucLana, chRemoteNameBuffer);
    }


    /* Delete the Name */
    ucRc =     DelName ( chLocalNameBuffer,
			 ucLana,
			 ucNameNum
		       );

    printf("DelName:: RC: [%x] \n", ucRc);

    return NetCleanUp ( 0 );
}

/*
 * FUNCTION    :: CallListen()
 * PARAMETERS  ::
 *   [in]     ucLana	    :- LAN adaptor numner over which to communicate.
 *   [in/out] pchRemoteName :- char pointer to a NetBIOS name of remote
 *				       listener/receiver
 *   [in]     pchLocalName  :- char pointer to a NetBIOS name of local
 *				       listener/receiver
 *
 * RETURN VALUE:
 *		NO_ERROR  if connection was sucessfull.
 *
 *		pchRemoteName will contain the name of the caller, if
 *		pchRemoteName was '*' and operation was NCB.RECEIVE.
 *
 * Comments:
 *	    Provides a NetBIOS connection between local
 *	    name and remote name.
 *
 */
BOOL CallListen   ( unsigned char ucLana,
		    char far *pchRemoteNameBuffer,
		    char far *pchLocalNameBuffer,
		    unsigned char far *ucLsn)

{
    int mode;
    int ch;
    unsigned	char	ucRc;

    mode = LISTEN;
    printf("Default mode is Listen.\n");
    printf("Press ESC to change  to Call mode, Else press enter.\n");
    printf("Press <cntrl><z> to quit. \n");

    ch = getch ();
    if (ch==_EOF_)
	return FALSE;
    if (ch==ESC)
	mode = CALL;


    if (mode==LISTEN)
    {
	printf("Listening for %16.16s\n", pchRemoteNameBuffer);
	ucRc = Listen( ucLana,
		       pchRemoteNameBuffer,
		       pchLocalNameBuffer,
		       SEND_TIME_OUT,
		       RECEIVE_TIME_OUT,
		       ucLsn
		     );
	if (ucRc)
	    printf("Error in Listen: RC: [%x]\n", ucRc);
    }
    else
    {
	printf("Calling  %16.16s\n", pchRemoteNameBuffer);
	ucRc = Call(	ucLana,
		       pchRemoteNameBuffer,
		       pchLocalNameBuffer,
		       SEND_TIME_OUT,
		       RECEIVE_TIME_OUT,
		       ucLsn
		   );
	if (ucRc)
	    printf("Error in Call: RC: [%x]\n", ucRc);

    }

    printf("\n\n");
    /* Return success or failure */

    return ( (ucRc)?FALSE:TRUE);

}

/*
 * FUNCTION    :: SendReceive()
 * PARAMETERS  ::
 *	  [in] ucLsn	    :- Local session number
 *	  [in] ucLana	    :- LAN adaptor numner over which to communicate.
 *	  [in] pchRemoteName :- char pointer to a NetBIOS name of remote
 *			       listener/receiver.

 *
 * RETURN VALUE:
 *		NONE.
 * Comments:
 *	    Provides a very simple one-way TTy service between a local
 *	    name and remote name.
 *
 */

void SendReceive ( unsigned char ucLsn, unsigned char ucLana, char * pchRemoteName)
{
    int mode;
    int ch;
    char	chLine [ LINE_SIZE ];
    unsigned	short	usLineSize, i;
    unsigned	char	ucRc;

    mode = RECEIVE;
    printf("Default mode is Receive.\n");
    printf("Press ESC to change  mode, Else press enter.\n");
    printf("Press <cntrl><z> to quit. \n");

    ch = getch ();
    if (ch==_EOF_)
	return	(void) HangSess ( ucLana, ucLsn);
    if (ch==ESC)
	mode = SEND;

    do
    {
	switch (mode)
	{
	    case SEND:
		printf("Send to [%16.16s]: ", pchRemoteName);
		ch = GetLine (chLine);

		printf("\n");

		if (ch==ESC)
		    { mode = RECEIVE; break; }

		if (ch==_EOF_)
		{
		    chLine [ 0 ]= -1;
		    chLine [ 1 ]= '\0';
		}

		ucRc = SendSess (      ucLana,
				       ucLsn,
				       chLine,
				       strlen(chLine)
				);
		if (ch==_EOF_)
		    return (void) HangSess ( ucLana, ucLsn);

		if (ucRc)
		{
			printf("Error Sending Packet: RC: [%x]\n", ucRc);
			return (void) HangSess ( ucLana, ucLsn);
		}

	    break;

	    case RECEIVE:
		printf("Receiveing from [%16.16s]: ", pchRemoteName);

		usLineSize = LINE_SIZE;
		ucRc = ReceiveSess ( ucLana,
				     ucLsn,
				     chLine,
				     &usLineSize
				   );
		if (ucRc)
		{
			printf("Error Receiving Packet: RC: [%x]\n", ucRc);
			return (void) HangSess ( ucLana, ucLsn);
		}
		else
		{
		    if (chLine [ 0 ] == -1 )
		    {
			printf("Remote user Hang Up\n");
			return (void) HangSess ( ucLana, ucLsn);
		    }

		    for (i= 0; i< usLineSize; i++)
			printf("%c", chLine [i]);
		    printf("\n");
		}

		/*
		 * check if user wants to get out or change mode. Yes, this
		 * is definitely boring as receiver has to keep hiting
		 * the key board. This problem is solved by implementing
		 * async. receive.
		 */
		ch = getch ();
		if (ch==_EOF_)
		    return (void) HangSess ( ucLana, ucLsn);
		if (ch==ESC)
		   mode = SEND;
	    break;
	}

    } while (ch != _EOF_);

    return (void) HangSess ( ucLana, ucLsn);

}

/*
 * FUNCTION    :: GetLine()
 * PARAMETERS  ::
 *	 [in/out] pchBuffer:- char pointer to a buffer which will receive
 *			      user input.
 *
 * RETURN VALUE:
 *		The last character typed by the user.
 * Comment:
 *		Allows user to type in a LINE_SIZE big line or simply
 *		a ESC or <control><z>
 */


int GetLine ( char *pchBuffer)
{
    int ch, index;

    index = 0 ;
    do
    {
	ch = getch();
	if ((ch == ESC) || (ch == _EOF_))
	    return ch;

	putch( ch );
	pchBuffer [index++] = ch;

	if (ch == NEWLINE)
	{
	    pchBuffer [index] = '\0';
	    return ch;
	}

    } while ( index < LINE_SIZE);

}
