
//   LANGS.C - DLL for language translation

#include <windows.h>
#define STRINGSIZE 50

static char LangFile[68];     // name of translation file
static char x[STRINGSIZE+2];  // buffer for returned string

#pragma argsused
int FAR PASCAL LibMain( HANDLE hInstance, WORD wDataSeg,
                         WORD wHeapSize, LPSTR lpszCmdLine )
{ if( wHeapSize > 0 )
    UnlockData( 0 );
  return 1;
}

/**********************************************************
 *  Purpose: establishes name of language file to be used *
 **********************************************************/
BOOL FAR PASCAL SetLang( LPSTR v )
{ BOOL retval = FALSE;
  int fp;
  lstrcpy( LangFile, v );
  fp = _lopen( LangFile, OF_SHARE_DENY_NONE );
  if( fp != -1 )
    { _lclose( fp );
      retval = TRUE;
    }
  return retval;
}

/**********************************************************
 *  Purpose: extracts string 'n' from the file to bfr 's' *
 **********************************************************/
void FAR PASCAL langstr( int n, LPSTR s )
{ int i, fp = _lopen( LangFile, OF_SHARE_DENY_NONE );
  x[0] = x[STRINGSIZE] = 0;
  *s = '\0';
  if( n > 0 )
    { _llseek( fp, (long)(n-1) * STRINGSIZE, 0 );
      i = _lread( fp, x, STRINGSIZE );
      while( i>=0 )
        { if( x[i] > ' ' )
            break;
          i--;
        }
      x[i+1] = 0;
    }
  _lclose( fp );
  lstrcpy( s, (LPSTR) x );
}
