/*
//
// NOS.H
//
// (c) Copyright 1989, 1990, 1991 Artisoft Inc.
// (c) Copyright 1990, 1991 Adrian King.
//
// $Header:   C:/USR/LANBOOK/SRC/H/VCS/NOS.H_V   1.0   29 Aug 1991 13:26:16  $
//
// $Log:   C:/USR/LANBOOK/SRC/H/VCS/NOS.H_V  $
//
//   Rev 1.0   29 Aug 1991 13:26:16
//Initial revision.
//
// Header file for LANtastic specific structures and constants.
// All of these definitions are derived from information published
// by Artisoft on their support bulletin board (Tel: 602 293 0065)
// within the LANtastic NOS conference. (See the file TECH.ZIP for
// the original source of the information.) 
//
// As such, much of this material is (c) copyright Artisoft Inc.
// The translation to the C language is (c) Adrian King. Artisoft
// kindly granted permission to use their material for the translation.
// However, any mistakes are definitely (c) Adrian King.
//
// Wherever possible, mnemonics and definitions used within the
// original Artisoft (assembler based) document have been retained.
// C types, structure definitions and additional mnemonics have been 
// added where it makes sense.
//
// This file has been used successfully with both Borland Turbo C
// and Microsoft C compilers. 
// 
*/

	// Type definitione

#ifndef WINDOWS
typedef unsigned char BYTE;		// Single byte
typedef void (far *FARPROC)();	// Pointer to far void procedure
typedef short BOOL;				// Boolean. Set TRUE or FALSE.
typedef unsigned short WORD;	// 16 bit quantity
typedef unsigned long DWORD;	// 32 bit quantity
#endif

	// Constant definitions
		
#ifndef	D_NAMESZ	
#define	D_NAMESZ	16			// Length of a name
#endif

#include "ncb.h"				// Defines NetBIOS NCB stuff

	// User account structure

struct user_account	{
	BYTE	UA_name[D_NAMESZ];			// Zero padded username
	BYTE	UA_internal[D_NAMESZ];		
	BYTE	UA_description[32];			// Full user description
	BYTE	UA_privilege;				// Privilege bits 
										// (see definitions below)
	BYTE	UA_concurrent;				// Maximum concurrent log ins
	BYTE	UA_allowed_times[42];		// 1 bit for each half hour for 7 
										// days. Week begins Sunday.
										// 0 means allowed.
	WORD	UA_internal2;
	WORD	UA_last_login_time[2];		// Last time logged in
	WORD	UA_account_expiration[2]; 	// Expiration date (MSDOS-format)
										// Year, Month:Day
	WORD	UA_password_expiration[2];	// Expiration date (as above)
										// 0 means no expiration date.
	BYTE	UA_password_extension;		// 1-31  Number of days to reextend
										// password after change, 0 says no 
										// extension required
	BYTE	UA_undelete_char;			// First letter of UA_name when  
										// account is deleted (first 
										// character of UA_name is replaced 
										// with a zero.)
	BYTE	UA_xprivilege;				// Extended privilege
	BYTE	UA_future[3];		
};

	// Privilege bits for UA_privilege:

#define UA_privilege_superACL	0x80	// Bypass ACLs
#define UA_privilege_superqueue 0x40	// Bypass queue protection
#define UA_privilege_peer       0x20	// Treat as local process
#define UA_privilege_supermail  0x10	// Bypass mail protection
#define UA_privilege_audit      0x08	// User can create audit entries
#define UA_privilege_system     0x04	// User has system manager privileges
#define UA_xprivilege_nopwchange 0x01   // User cannot change password

#define	MB_textlen	80					// Length of message text buffer

										// Message buffer structure
struct message_buffer	 {
	BYTE	MB_reserved;				// Reserved field used by system call
	BYTE	MB_type;					// User defined message type 
										// (see below)
	BYTE	MB_machine[D_NAMESZ];		// Machine name destination
	BYTE	MB_server[D_NAMESZ];		// User must be logged into this
										// server
	BYTE	MB_user[D_NAMESZ];			// User must be using this username
	BYTE	MB_originator[D_NAMESZ];	// Originator's machine name. 
										// Filled when message is received
	BYTE	MB_text[MB_textlen];		// Message text
};

	// Message buffer type.  

#define	MBT_general	0					// General msg used by NET and others
#define MBT_warning	1					// Server warning message

	// Message service disposition

#define	MPB_beep		0x01			// Beep before delivering message
#define	MPB_deliver		0x02			// Deliver to message service
#define MPB_auto_pop_up	0x04			// Pop up messages automatically

	// Definition of a queue entry:

struct queue_entry {
	BYTE	QE_status;					// Status of queue entry
	DWORD	QE_size;					// Size of spooled file
	BYTE	QE_type;					// Type of queue entry
	BYTE	QE_output_control;			// Control of despooled file
	WORD	QE_copies;					// Number of copies
	DWORD	QE_sequence;				// Sequence number of queue entry
	BYTE	QE_spooled_file[48];		// Pathname of spooled file
	BYTE	QE_user[D_NAMESZ];			// Username who spooled file
	BYTE	QE_machine[D_NAMESZ];		// Machine name user was on
	WORD	QE_date;					// Date file spooled (MS-DOS format)
	WORD	QE_time;					// Time file spooled (MS-DOS format)
	BYTE	QE_destination[D_NAMESZ+1];	// ASCIZ Device or username destn.
	BYTE	QE_comment[48];				// Comment field
};

	// Different queue entry statuses:

#define	QE_status_free			0	// The queue entry is empty
#define	QE_status_update		1	// The queue entry is being updated
#define	QE_status_hold			2	// The queue entry is held
#define	QE_status_wait			3	// The queue entry is waiting for despool
#define	QE_status_active		4	// The queue entry is being despooled
#define	QE_status_cancel		5	// The queue has been canceled
#define	QE_status_file_error	6	// The spooled file could not be accessed
#define	QE_status_spool_error	7	// The destination could not be accessed
#define	QE_status_rush			8	// Rush this job
	
	// Different types of queue entries:
	
#define	QE_type_print		0	// Spooled printer queue file
#define	QE_type_message		1	// Spooled message (mail)
#define	QE_type_local_file	2	// Spooled local file
#define	QE_type_remote_file	3	// Spooled remote file
#define	QE_type_modem		4	// Spooled to remote modem
#define	QE_type_batch		5	// Spooled batch processor file

	// Definitions for output control:

#define QE_OC_keep	0x40	// Keep after despooling (don't delete)
							// Used for mail - allow delete only by owner

	// Definitions for mail

#define	QE_OC_voice	 			0x20	// Mail file contains voice data
#define QE_OC_opened 			0x10	// Message has been read
#define QE_OC_request_response 	0x04	// Response requested

	// Control queue commands.

#define	CQ_start			0	// Start despooling
#define	CQ_halt				1	// Halt despooling
#define CQ_halt_EOJ			2	// Halt despooling at end of job
#define	CQ_pause			3	// Pause the despooler at end of job
#define	CQ_single			4	// Print single job
#define CQ_restart			5	// Restart the current print job
#define CQ_cancel			6	// Cancel the currently printing job
#define CQ_hold				7	// Hold the queue entry
#define	CQ_release			8	// Release a held queue entry
#define	CQ_rush				9	// Make the queue entry a rushed job


	// Definition of printer states:

struct printer_state {
	BYTE	PS_state_pause:1;	// Set 1 when printer paused
	BYTE	PS_state_value:7;	// Set to PS_state_ value (see below)
};

#define	PS_state_disabled	0	// Printer is disabled
#define	PS_state_single_job	1	// Printer will stop at end of job
#define	PS_state_multijob	2	// Printer should print multiple jobs

	// Definition of a printer status entry:

struct PS {
							// Printer state
	struct	printer_state	PS_state;		
	WORD	PS_index;		// Queue index corresponding to print job 
							// being despooled. -1 if not despooling.
	WORD	PS_CPS;			// Actual characters per second being output
	DWORD	PS_output_chars;// Characters actually output so far
	DWORD	PS_read_chars;	// Characters actually read from despooled 
							// file so far. May be used to compute 
							// percent completed.
	WORD	PS_copies;		// Copies remaining to print
};

	// Definition of logical stream entry:

struct logical_stream {
	BYTE	LS_queue;		// 0 Disabled, non-zero Enabled
	BYTE	LS_template[13];// Template may contain ?'s (include "." as 
							// in @???????.???)
};

	// Definition of active user entry:

struct active_user_entry {
	WORD	AUE_VCID;				// Virtual circuit number
	BYTE	AUE_state;				// Login state (defined below)
	BYTE	AUE_command;	   		// Last command issued
	BYTE	AUE_IO[5];				// Number of I/O bytes (40 bit number)
	BYTE	AUE_requests[3];		// Number of server requests (24 bits)
	BYTE	AUE_name[D_NAMESZ];		// Name of logged in user
	BYTE	AUE_machine[D_NAMESZ];	// Name of remote logged in machine
	BYTE	AUE_xprivilege;			// Extended privileges
	WORD	AUE_time_left;			// Time left in minutes
};

	// Definition of the various login states and privileges:

#define AUE_state_starting	 		0x00	// We are in the middle of login
#define AUE_state_in		 		0x01	// We are fully logged in
#define AUE_state_RPL		 		0x02	// Remote program load login

#define AUE_privilege_superACL	 	0x80	// Bypass ACLs
#define AUE_privilege_superqueue	0x40	// Bypass queue protection
#define AUE_privilege_peer       	0x20	// Treat as local process
#define AUE_privilege_supermail  	0x10	// Bypass mail protection
#define AUE_privilege_audit      	0x08	// User can create audit entries
#define AUE_privilege_system     	0x04	// User has system manager privs
#define AUE_xprivilege_nopwchange	0x01	// User cannot change his password

	// Active user entry commands:

#define AUEC_login				0	// Login into a server
#define AUEC_terminate			1	// Process termination
#define AUEC_open				2	// Open a file
#define AUEC_close				3	// Close a file
#define AUEC_create				4	// Create a file if it's there or not
#define AUEC_new				5	// Create a new file that is not there
#define AUEC_unique				6	// Create a unique file
#define AUEC_commit				7	// Commit disk data to disk
#define AUEC_read				8	// Read from file
#define AUEC_write				9	// Write to file
#define AUEC_delete				10	// Delete file
#define AUEC_set_attr			11	// Set file attributes
#define AUEC_lock				12	// Lock byte range
#define AUEC_unlock				13	// Unlock byte range
#define AUEC_create_dir			14	// Create a subdirectory
#define AUEC_delete_dir			15	// Delete a subdirectory
#define AUEC_rename_file		16	// Rename a file
#define AUEC_find_first			17	// Find first matching file
#define AUEC_find_next			18	// Find the next matching file
#define AUEC_disk_free			19	// Get disk free space
#define AUEC_get_queue			20	// Get a queue entry
#define AUEC_set_queue			21	// Set a queue entry
#define AUEC_control_queue		22	// Control the queue
#define AUEC_get_login			23	// Return login information
#define AUEC_get_link			24	// Return link description
#define AUEC_seek				25	// Seek to a file position
#define AUEC_get_time			26	// Get server's time
#define AUEC_audit				27	// Create audit entry
#define AUEC_multi_open			28	// Open file in a multitude of modes
#define AUEC_change_password	29	// Change a password
#define AUEC_disable_account	30	// Disable account from further log ins
#define AUEC_copy_file			31	// Local server file copy
#define AUEC_get_username		32	// Get a username from account file
#define AUEC_translate_path		33	// Translate a server's logical path
#define AUEC_create_indirect	34	// Make indirect file
#define AUEC_get_indirect		35	// Get indirect file text
#define AUEC_printer_status		36	// Printer status obtained
#define AUEC_get_stream			37	// Get logical print stream information
#define AUEC_set_stream			38	// Set logical print stream information
#define AUEC_get_account		39	// Get an account record
#define AUEC_shutdown			40	// Request server shutdown
#define AUEC_cancel_shutdown	41	// Cancel server shutdown
#define AUEC_stuff				42	// Stuff server keyboard
#define AUEC_write_with_commit	43	// Commit data to disk

	// ACL bit definition:

#define ACL_read		0x8000	// (R) Allow reading
#define	ACL_write		0x4000	// (W) Allow writing
#define ACL_create_file 0x2000	// (C) Allow file creation
#define ACL_create_dir  0x1000	// (M) Allow directory creation
#define ACL_lookup      0x0800	// (L) Allow lookups
#define ACL_delete_file	0x0400	// (D) Allow file deletion
#define ACL_delete_dir  0x0200	// (K) Allow directory deletion
#define ACL_rename      0x0100	// (N) Allow file renaming
#define ACL_execute     0x0080	// (E) Allow program execution
#define ACL_physical    0x0040	// (P) Allow physical access
#define ACL_attribute   0x0020	// (A) Allow attribute changing
#define ACL_indirect	0x0010	// (I) Allow indirect file expansion

	// Definition of time buffer:

struct time_block {
	WORD	TB_year;		// Year
	BYTE	TB_day;			// Day of month (1-31)
	BYTE	TB_month;		// Month (1-12)
	BYTE	TB_minutes;		// Minutes (0-59)
	BYTE	TB_hour;		// Hour (0-23)
	BYTE	TB_hundredths;	// Hundredths of seconds (0-99)
	BYTE	TB_seconds;		// Seconds (0-59)
};

	// Definition of server shutdown option flags

#define SHUTDOWN_option_reboot		0x0001	// Reboot after shutdown
#define SHUTDOWN_option_silent		0x0002	// Do not notify users
#define SHUTDOWN_option_halt		0x0004	// Halt after shutdown
#define SHUTDOWN_option_powerfail	0x0008	// Shutdown due to power fail
											// (Used by UPS.)
#define SHUTDOWN_option_reserved1	0x0010	// RESERVED
#define SHUTDOWN_option_reserved2	0x0020
#define SHUTDOWN_option_reserved3	0x0040
#define SHUTDOWN_option_reserved4	0x0080
#define SHUTDOWN_option_user1		0x0100	// User definable
#define SHUTDOWN_option_user2		0x0200
#define SHUTDOWN_option_user3		0x0400
#define SHUTDOWN_option_user4		0x0800
#define SHUTDOWN_option_user5		0x1000
#define SHUTDOWN_option_user6		0x2000
#define SHUTDOWN_option_user7		0x4000
#define SHUTDOWN_option_reserved5	0x8000	// RESERVED

	// Multiplex interrupt (2F) calls

#define NOS_Presence			0xb800	// NOS loaded?
#define NOS_Share_Presence		0x1000	// SHARE loaded?
#define	NOS_Get_Version			0xb809	// Get NOS version numbers

	// Interrupt 2A functions

#define	NOS_Get_Resources		0x0500	// Get resource information
#define NOS_Set_Combine			0x0601	// Set combined output mode
#define NOS_Set_Separate		0x0602	// Set separated mode
#define NOS_2A_Flush			0x0603	// Flush output

	// Interrupt 21 functions for printers

#define	NOS_Get_Printer_Mode	0x5D07	// Return printer mode
#define NOS_Set_Printer_Mode	0x5D08	// Set printer mode
#define	NOS_Flush				0x5D09	// Flush output

	// DOS compatible network calls

#define NOS_Get_Machine_Name	0x5E00	// Get Machine Name
#define NOS_Set_Printer_Setup	0x5E02	// Set Printer Setup
#define NOS_Get_Printer_Setup	0x5E03	// Get Printer Setup
#define NOS_Get_Redir_Device	0x5F02	// Get Redirected Device Entry
#define NOS_Redir_Device		0x5F03	// Redirect Device
#define NOS_Cancel_Redir		0x5F04	// Cancel Device Redirection

	//  LANtastic network calls

#define NOS_Get_Login		0x5F80	// Get Login Entry
#define NOS_Login			0x5F81	// Login to a Server
#define NOS_Logout			0x5F82	// Logout of a Server
#define NOS_Get_User_Name	0x5F83	// Get Username Entry
#define NOS_Get_Server		0x5F84	// Get Inactive Server Entry
#define NOS_Change_Password	0x5F85	// Change Password
#define NOS_Disable			0x5F86	// Disable Account
#define NOS_Get_Account		0x5F87	// Get Account
#define NOS_Logout_All		0x5F88	// Logout from all servers
#define NOS_Copy_File		0x5F97	// Copy File
#define NOS_Send_Msg		0x5F98	// Send Unsolicited Message
#define NOS_Get_Msg			0x5F99	// Get Last Received Unsolicited Message
#define NOS_Get_Msg_Flag	0x5F9A	// Get Message Processing Flag
#define NOS_Set_Msg_Flag	0x5F9B	// Set Message Processing Flag
#define NOS_Popup_Msg		0x5F9C	// Pop Up Last Received Message
#define NOS_Get_Queue		0x5FA0	// Get Queue Entry
#define NOS_Set_Queue		0x5FA1	// Set Queue Entry
#define NOS_Control_Queue	0x5FA2	// Control Queue
#define NOS_Get_Status		0x5FA3	// Get Printer Status
#define NOS_Get_Stream_Info	0x5FA4	// Get Stream Info
#define NOS_Set_Stream_Info	0x5FA5	// Set Stream Info
#define NOS_Create_Audit	0x5FA7	// Create User Audit Entry
#define NOS_Get_User_Info	0x5FB0	// Get Active User Information
#define NOS_Get_Dir_Info	0x5FB1	// Get Shared Directory Information
#define NOS_Get_User_Acct	0x5FB2	// Get Username From Account File
#define NOS_Translate_Path	0x5FB3	// Translate Path
#define NOS_Create_Indir	0x5FB4	// Create Indirect File
#define NOS_Get_Indir		0x5FB5	// Get Indirect File Contents
#define NOS_Get_Time		0x5FC0	// Get Server's Time
#define NOS_Shutdown		0x5FC8	// Schedule Server Shutdown
#define NOS_Cancel_Shutdown	0x5FC9	// Cancel Server Shutdown
#define NOS_Stuff_Server	0x5FCA	// Stuff Server Buffer
#define NOS_Get_LPT_Timeout	0x5FD0	// Get Redirected Lineprinter Timeout
#define NOS_Set_LPT_Timeout	0x5FD1	// Set Redirected Lineprinter Timeouts
#define NOS_Get_DOS_Vector	0x5FE0	// Get DOS Service Vector
#define NOS_Set_DOS_Vector	0x5FE1	// Set DOS Service Vector
#define NOS_Get_Msg_Vector	0x5FE2	// Get Message Service Vector
#define NOS_Set_Msg_Vector	0x5FE3	// Set Message Service Vector
