#include <stdio.h>
#include <conio.h>
#include <dos.h>

#include "nos.h"
#include "noslib.h"
#include "netusers.h"
#include "version.h"
#include "proto.h"

//
//  NETUSERS.EXE
//
//  See Usage () for comments
//
//  This program uses the Borland C versions of the nos library included in
//  the file 'book.zip' on the Artisoft BBS (602-293-0065) and was compiled
//  using Borland C++.
//
//  Written by Alan R. Roney
//
//  Released into the public domain by the author.  The author accepts no
//  responsiblity for any problems associated with use of this program.
//
//  This software is not to be included in any "for profit" software packages.
//
//  You are welcome to modify the source code for this program.  Please
//  forward a copy of your changes to the author.
//
//  Comments and suggested changes should be directed to the author at:
//
//	    Compuserve:     76330,3711
//	    Internet:	    76330.3711@compuserve.com
//	    Artisoft:	    alan roney
//


struct serverdef *server;
struct localuserlistdef *localuserlist;
struct localuserlistdef *startup_localuserlist;
struct localuserlistdef *previous_localuserlist;

int currentserver, adaptornum, numberoflogins, currentprinter, found;
int userlistjobcount, printjobcount;
int maxlocaluserlistcount, localuserlistcount;
int monoflag, singleflag;

char	servername [D_NAMESZ + 2];

struct time_block servertime;
struct active_user_entry serveraue;

void main (int argc, char *argv [])
    {
    int i, j;
    int show_title;
    char buf [50];

    monoflag = false;
    singleflag = false;
    show_title = true;

    for (i = 1; i < argc; i++)
	{
	if ( (argv [i] [0] == '-') || (argv [i] [0] == '/') )
	    {
	    for (j = 1; argv [i] [j] != '\0' ; j++)
		{
		switch (argv [i] [j])
		    {
		    case 'm':
		    case 'M':
			monoflag = true;
			break;

		    case 's':
		    case 'S':
		    case '1':
			singleflag = true;
			break;

		    case 'h':
		    case 'H':
		    case '?':
			Usage ();
			exit ();
			break;

		    }
		}
	    }
	}

    setup ();

    do
	{
	getserverinfo ();

	if (!singleflag)
	    clrscr ();

	if (startup_localuserlist [0] .AUE_machine [0] == '\0')
	    {
	    copy_userlist_to_startup ();
	    copy_userlist_to_update ();
	    }

	reportinfo ();

	if (show_title)
	    {
	    sprintf (buf, "NETUSERS.EXE   Version %d.%02d\0", MAJOR_VERSION, MINOR_VERSION);
	    message (buf, false);
	    show_title = false;
	    }


	if (!singleflag)
	    {
	    copy_userlist_to_update ();

	    i = 0;
	    while (i++ < 2)
		{
		sleep (1);
		if (kbhit () != 0)
		    break;
		}
	    }
	}while ( (kbhit () == 0) && !singleflag);


    lowvideo ();
    textcolor (LIGHTGRAY);
    if (!singleflag)
	clrscr ();

    free (server);
    free (localuserlist);
    }


void setup ()
    {
    //	Check for presence of NOS Version 4.0 or greater

    if (NOSPresence () == -1)
	{
	printf ("NOS not installed\n");
	exit (1);
	}

    if (NOSGetVersion () < 1024)
	{
	printf ("Incorrect NOS Version\n");
	exit (1);
	}

    //	Find out how many servers this node is logged into

    numberoflogins = 0;
    servername [0] = servername [1] = '\\';

    while (NOSGetLogin (&numberoflogins, &servername [2], &adaptornum) != -1)
	numberoflogins++;

    if (numberoflogins <= 0)
	{
	printf ("Not logged into to any servers\a\n");
	exit (1);
	}

    //	open structures for storing information

    if ( (server = (struct serverdef *) calloc (numberoflogins,
	sizeof (struct serverdef))) ==	(struct serverdef *) 0)
	{
	printf ("Couldn't allocate space for server information\n");
	exit (1);
	}

    maxlocaluserlistcount = 60;
    if ( (localuserlist = (struct localuserlistdef *)
	calloc (maxlocaluserlistcount, sizeof (struct localuserlistdef)))
	 ==  (struct localuserlistdef *) 0)
	{
	printf ("Couldn't allocate space for userlist information\n");
	exit (1);
	}

    if ( (previous_localuserlist = (struct localuserlistdef *)
	calloc (maxlocaluserlistcount, sizeof (struct localuserlistdef)))
	 ==  (struct localuserlistdef *) 0)
	{
	printf ("Couldn't allocate space for previous userlist information\n");
	exit (1);
	}

    if ( (startup_localuserlist = (struct localuserlistdef *)
	calloc (maxlocaluserlistcount, sizeof (struct localuserlistdef)))
	 ==  (struct localuserlistdef *) 0)
	{
	printf ("Couldn't allocate space for startup userlist information\n");
	exit (1);
	}

    //	Get server names and userlist privileges

    currentserver = 0;

    while (currentserver < numberoflogins)
	{
	if (NOSGetLogin (&currentserver, &servername [2], &adaptornum) == -1)
	    NOSperror ("NOSGetLogin");

	strcpy (server [currentserver] .servername, servername);
	currentserver++;
	}

    qsort ( (void *) server, numberoflogins, sizeof (struct serverdef), comparestring);
    }


void Usage ()
    {
    int i;

    printf ("\nNETUSERS.EXE   Version");
    printf (" %d.%02d", MAJOR_VERSION, MINOR_VERSION);
    i = BETA_VERSION;
    if (i > 0)
	printf (".%02d", BETA_VERSION);
    printf ("\n\n");

    printf ("Displays active user names on all logged on servers.  The display\n");
    printf ("    updates every two seconds.  Users who have requested data from\n");
    printf ("    the server since the last update are highlighted\n\n");
    printf ("Users who are logged on through an adaptor other than 0 will have \n");
    printf ("    an asterisk '*' next to their name.\n\n");
    printf ("If you are using a monochrome monitor, you may need to use the /m\n");
    printf ("    switch to inhibit color selections.\n\n");
    }


void copy_userlist_to_startup ()
    {
    int i, j;

    for (i = 0; i < localuserlistcount; i++)
	{
	strcpy (startup_localuserlist [i] .AUE_machine,
	    localuserlist [i] .AUE_machine);

	strcpy (startup_localuserlist [i] .name_machine,
	    localuserlist [i] .name_machine);

	for (j = 0; j < 3; j++)
	    startup_localuserlist [i] .AUE_requests [j] =
		localuserlist [i] .AUE_requests [j];

	startup_localuserlist [i] .server = localuserlist [i] .server;
	}
    }


void copy_userlist_to_update ()
    {
    int i, j;

    for (i = 0; i < localuserlistcount; i++)
	{
	strcpy (previous_localuserlist [i] .AUE_machine,
	    localuserlist [i] .AUE_machine);

	strcpy (previous_localuserlist [i] .name_machine,
	    localuserlist [i] .name_machine);

	for (j = 0; j < 3; j++)
	    previous_localuserlist [i] .AUE_requests [j] =
		localuserlist [i] .AUE_requests [j];

	previous_localuserlist [i] .server = localuserlist [i] .server;
	}
    }
