#include sf_gui.hdr
#include system.hdr
#include fileio.hdr
#include iif.hdr
#include io.hdr
#include string.hdr
#include pick.hdr

dbfdef cpcsusp
  char( 15 ) lastname
enddef

indexdef
  char( 15 ) idnum  cpcsusp->lastname
enddef

vardef extern
  byte    __class_max_lr
  byte    __class_max_lc
  byte    __class_max_rr
  byte    __class_max_rc
  byte    __class_min_lr
  byte    __class_min_lc
  byte    __class_min_rr
  byte    __class_min_rc
enddef

procedure general_info
  clear
  ? ""
  ? " Welcome to the Special Forces GUI Library demo!!!"
  ? ""
  ? " The following demonstration requires a VGA card and monitor."
  ? " A mouse, XMS memory and a disk cache are optional but greatly"
  ? " increase the preformance of the system.  Ordering information"
  ? " is contained in the README.DOC file within this demo, which is"
  ? " also viewable during this demo under the file menu."
  ? ""
  ? " Note: The browse, picklist, image browse etc. windows are movable"
  ? "       and resizable.  To move a window, click and hold a mouse button"
  ? "       with the mouse cursor on the window heading, then move it to"
  ? "       the new locatiion.  To resize a window, click and hold a mouse"
  ? "       button on the bottom right blank button of a window, then move"
  ? "       your mouse.  If you do not have a mouse, use TAB, SHIFT-TAB and"
  ? "       the arrow keys to move around."
  ? ""
  ? " Hope you enjoy this!"
  ? " Mark N. Witten"
  ? ""
  wait
endpro

procedure order_lib
  gui_validate( "To place an order for the Special Forces GUI;" +;
                "Library, by check, M/O, Visa or Master Card:;" +;
                ";" + "I.C.B.;" +;
                "3102 White Cloud Road;" +;
                "Cheyenne, WY 82001;" + ";" +;
                "Visa/MC Voice: (307) 634-8403;" +;
                "Fax: (307) 638-6867;" +;
                "Tech questions? Voice or Fax: (609) 265-0921;",;
                -1, -1, 0, 15, "Order Information", 15, 1, .t.,;
                .t., &BMP_INFORMATION, 3 )
endpro

procedure udf_func
endpro

procedure browse_dbf
  vardef
    char( 30 ) field_array[ 8 ]
    char( 10 ) include_array[ 8 ]
  enddef
  open "suspd000.dbf" alias cpcsusp
  index "idnui000.fdx" alias idnum
  set index to idnum
  field_array[ 0 ] = "Id Number"
  field_array[ 1 ] = "First Name"
  field_array[ 2 ] = "Last Name"
  field_array[ 3 ] = "Date of Birth"
  field_array[ 4 ] = "Notation"
  field_array[ 5 ] = "Occupation/Trade"
  field_array[ 6 ] = "Current Employment"
  field_array[ 7 ] = "S.S. Number"
  include_array[ 0 ] = "IDNUMBER"
  include_array[ 1 ] = "FIRSTNAME"
  include_array[ 2 ] = "LASTNAME"
  include_array[ 3 ] = "BIRTHDATE"
  include_array[ 4 ] = "NOTES"
  include_array[ 5 ] = "OCCUPATION"
  include_array[ 6 ] = "EMPLOY1"
  include_array[ 7 ] = "SSNUMBER"
  *\ Set the min and max
  __class_max_lr = 3
  __class_max_lc = 2
  __class_max_rr = 27
  __class_max_rc = 77
  __class_min_lr = 22
  __class_min_lc = 2
  __class_min_rr = 27
  __class_min_rc = 9
  gui_browse( cpcsusp, 3, 4, 22, 75, 0, 7, 1, 15, "Gui_Browse()",;
              15, 1, 0, 14, field_array[], include_array[], 8, .t., .t., .t., udf_func )
  close( cpcsusp )
endpro

procedure picklist
  parameters const char filename
  vardef
    long plist
    file handle
    char buffer
  enddef
  plist = pick_init()
  f_open( handle, filename, &F_READ )
  do while .not. f_eof( handle )
    f_getln( handle, buffer )
    pick_add( plist, buffer )
  enddo
  f_close( handle )
  *\ Set the min and max
  __class_max_lr = 3
  __class_max_lc = 2
  __class_max_rr = 27
  __class_max_rc = 77
  __class_min_lr = 22
  __class_min_lc = 2
  __class_min_rr = 27
  __class_min_rc = 9
  gui_pick_list( plist, 3, 37, 27, 71, .f., .f., 0, 7, 15,;
                 "Gui_Pick_List()", 15, 1, 1, .t., .t., .t., udf_func )
  pick_clear( plist )
endpro

procedure force_main
  vardef
    long       object, l_sub1, l_sub2, l_sub3
    int        object_selected, menu_level, cnt, xcnt
    uint       selected_list, headof_list
    logical    lvar1, lvar2, lvar3, lvar4, really_exit
    char( 15 ) get_variable1, get_variable2
    char       arr[ 10 ], xarr[ 5 ]
    char       tsave
  enddef

  general_info()

  *\ General setup...
  really_exit = .f.
  scrn_dos()
  gui_init()

  gui_load_bmp2xms()
  on error do gui_error_system

  *\ Define pulldown menus
  l_sub1 = gui_menu_init()
  l_sub2 = gui_menu_init()
  l_sub3 = gui_menu_init()
  gui_menu_add( l_sub1, " DBF ^Browse demo       ", 3, 6 )
  gui_menu_add( l_sub1, " Picklist ^demo         ", 4, 6 )
  gui_menu_add( l_sub1, " ^Validate dialog       ", 5, 6 )
  gui_menu_add( l_sub1, " ^Image browse demo     ", 7, 6 )
  gui_menu_add( l_sub1, " ^Animation demo        ", 8, 6 )
  gui_menu_add( l_sub1, " ^Dialog window demo    ", 9, 6 )
  gui_menu_add( l_sub1, " Me^nu prompt 1, 7      ", 10, 6 )
  gui_menu_add( l_sub1, " Men^u prompt 1, 8      ", 11, 6 )
  gui_menu_add( l_sub1, " Menu p^rompt 1, 9      ", 13, 6 )
  gui_menu_add( l_sub1, " Menu pr^ompt 1, 10     ", 14, 6 )
  gui_menu_add( l_sub1, " Menu promp^t 1, 11     ", 15, 6 )
  gui_menu_add( l_sub1, " View ^README.DOC file  ", 17, 6 )
  gui_menu_add( l_sub1, " View ^GUIDEMO.PRG file ", 18, 6 )
  gui_menu_add( l_sub2, " Display ^Squares Wallpaper ", 3, 21 )
  gui_menu_add( l_sub2, " Display ^Castle Wallpaper  ", 4, 21 )
  gui_menu_add( l_sub2, " Display ^Rivets Wallpaper  ", 5, 21 )
  gui_menu_add( l_sub2, " Display ^Boxes Wallpaper   ", 6, 21 )
  gui_menu_add( l_sub2, " Display ^Egypt Wallpaper   ", 7, 21 )
  gui_menu_add( l_sub3, " ^Yes, exit the system    ", 3, 37 )
  gui_menu_add( l_sub3, " ^No, do not exit system  ", 4, 37 )
  *\ End menu creation

  *\ Set up some variables
  *- for radio buttons
  lvar1 = .t.
  lvar2 = .f.
  lvar3 = .t.
  lvar4 = .f.
  *- for gets
  get_variable1 = "   -      -    "   &&space( 15 )
  get_variable2 = space( 15 )
  *- for list box
  selected_list = 0
  headof_list   = 0
  xarr[ 0 ] = "squares.$$$"
  xarr[ 1 ] = "castle.$$$"
  xarr[ 2 ] = "rivets.$$$"
  xarr[ 3 ] = "boxes.$$$"
  xarr[ 4 ] = "egypt.$$$"
  arr[ 0 ] = " Squares Wallpaper "
  arr[ 1 ] = " Castle Wallpaper  "
  arr[ 2 ] = " Rivets Wallpaper  "
  arr[ 3 ] = " Boxes Wallpaper   "
  arr[ 4 ] = " Egypt Wallpaper   "
  arr[ 5 ] = " N/A Wallpaper     "
  arr[ 6 ] = " N/A Wallpaper     "
  arr[ 7 ] = " N/A Wallpaper     "
  arr[ 8 ] = " N/A Wallpaper     "
  arr[ 9 ] = " N/A Wallpaper     "

  gui_wallpaper( "squares.$$$", -1, .f. )

  *\ Do while to allow screen redraw
  do while .t.

    *\ Draw the screen stuff
    gui_say_string( space( 80 ), 0, 0, 0, 1 )
    gui_say_string( "Object Test/Demo program", 0, 29, 15, 1 )
    gui_say_string( space( 80 ), 1, 0, 0, 15 )
    gui_raised_tile( 3, 8, 11, 71, 7, 4 )
    gui_raised_tile( 25, 1, 27, 78, 7, 3 )
    gui_raised_tile( 14, 1, 22, 30, 7, 3 )
    gui_raised_tile( 14, 49, 22, 78, 7, 3 )
    gui_sunken_box( glr( 15 ) - 8, glc( 2 ), grr( 21 ) + 8, grc( 29 ) )
    gui_say_string( "Printer setting 1: ", 15, 6, 15, 7 )
    gui_say_string( "Printer setting 2: ", 16, 6, 15, 7 )
    gui_say_string( "Printer setting 3: ", 17, 6, 15, 7 )
    gui_say_string( "Printer setting 4: ", 18, 6, 15, 7 )
    gui_rest_internal_bmp( "logo.vga", 4, 10, 9, 70 )
    gui_indented_box( glr( 4 ) - 6, glc( 9 ) + 2, grr( 10 ) + 4, grc( 70 ) - 4 )

    *\ Create screen objects
    object_create( 1 )

    *\ Create button objects
    object_button( 1, " DBF ^Browse ", 26, 3, 98 )
    object_button( 1, " ^Pick List ", 26, 17, 112 )
    object_button( 1, " ^Validate Dialogs ", 26, 30, 118 )
    object_button( 1, " ^Image Browse ", 26, 50, 105 )
    object_button( 1, " E^xit Demo ", 26, 66, 120 )

    *\ Create radio button objects
    object_radio_button( 1, 15, 25, lvar1, -1 )
    object_radio_button( 1, 16, 25, lvar2, -1 )
    object_radio_button( 1, 17, 25, lvar3, -1 )
    object_radio_button( 1, 18, 25, lvar4, -1 )

    *\ Create picture button objects
    object_picture_button( 1, "ok.$$$", 20, 3, 21, 10, .f., 32827 )
    object_picture_button( 1, "cancel.$$$", 20, 12, 21, 19, .f., -1 )
    object_picture_button( 1, "help.$$$", 20, 21, 21, 28, .f., -1 )

    *\ Create menu objects
    object_menu( 1, 1, 5, "^File", 0, 15, 32801 )
    object_menu( 1, 1, 20, "^Edit", 0, 15, 32786 )
    object_menu( 1, 1, 36, "^Quit", 0, 15, 32784 )

    *\ Create get objects
    object_get( 1, 10, 22, get_variable1, 15, "!!!-!!!!!!-!!!!", 15, 8, -1 )
    object_get( 1, 10, 40, get_variable2, 15, "!!!-!!!!!!-!!!!", 15, 8, -1 )

    *\ Create list box object
    object_list_box( 1, arr[], &LIST_SUNKEN, 10, selected_list, headof_list, 15, 51, 21, 76, 0, 7, 3, -1 )

    do while .t.
      object_selected = object_getevent( 1 )
      do case
        case object_selected = 1
          event_button( " DBF ^Browse ", 26, 3 )
          browse_dbf()
        case object_selected = 2
          event_button( " ^Pick List ", 26, 17 )
          picklist( "guidemo.prg" )
        case object_selected = 3
          event_button( " ^Validate Dialogs ", 26, 30 )
          order_lib()
        case object_selected = 4
          event_button( " ^Image Browse ", 26, 50 )
          gui_image_browse( "demo2.vga", 3, 4, 22, 75,;
                            "Your header goes here!!!", 15, 1, .t., .t., .t., udf_func )
        case object_selected = 5
          event_button( " E^xit Demo ", 26, 66 )
          really_exit = .t.
          exit
        case object_selected = 6
          event_radio_button( 15, 25, lvar1 )
        case object_selected = 7
          event_radio_button( 16, 25, lvar2 )
        case object_selected = 8
          event_radio_button( 17, 25, lvar3 )
        case object_selected = 9
          event_radio_button( 18, 25, lvar4 )
        case object_selected = 10
          event_picture_button( "ok.$$$", 20, 3, 21, 10, .f. )
        case object_selected = 11
          event_picture_button( "cancel.$$$", 20, 12, 21, 19, .f. )
        case object_selected = 12
          event_picture_button( "help.$$$", 20, 21, 21, 28, .f. )
        case object_selected = 13
          event_menu( l_sub1, 0, 15, 7, 0, menu_level, 2, 5, 19, 29, .t. )
          do case
            case menu_level = 1
              browse_dbf()
            case menu_level = 2
              picklist( "guidemo.prg" )
            case menu_level = 3
              order_lib()
            case menu_level = 4
              gui_image_browse( "demo2.vga", 3, 4, 22, 75,;
                                "Your header goes here!!!", 15, 1, .t., .t., .t., udf_func )
            case menu_level = 5
              gui_savescrn( "ani.vga", 4, 16, 16, 44 )
              gui_window( 5, 17, 15, 42, 0, "<ESC> to close", 15, 1, .t., .f., .f., .t. )
              gui_play_ani( "clown.ani", .f. )
              gui_restscrn( "ani.vga", 4, 16, 16, 44, .t. )
            case menu_level = 6
              gui_savescrn( "die.vga", 09, 09, 21, 72 )
              gui_create_dialog( 10, 10, 20, 70, 15, 8, "Dialog Wrap Demo", 15, 1, .t., .t., .f. )
              for cnt = 0 to 800
                gui_dialog_line( trim( i_str( cnt ) ), .t. )
               next
               gui_restscrn( "die.vga", 09, 09, 21, 72, .t. )
            case menu_level = 12
              picklist( "readme.doc" )
            case menu_level = 13
              picklist( "guidemo.prg" )
          endcase
        case object_selected = 14
          event_menu( l_sub2, 0, 15, 7, 0, menu_level, 2, 20, 8, 48, .t. )
          if menu_level <> 0
            gui_wallpaper( xarr[ menu_level - 1 ], -1, .f. )
            really_exit = .f.
            exit
          endif
        case object_selected = 15
          event_menu( l_sub3, 0, 15, 7, 0, menu_level, 2, 36, 5, 62, .t. )
          if menu_level = 1
            really_exit = .t.
            exit
          endif
        case object_selected = 16
          get_variable1 = event_get( 10, 22, get_variable1, 15, "!!!-!!!!!!-!!!!", 15, 8 )
        case object_selected = 17
          get_variable2 = event_get( 10, 40, get_variable2, 15, "!!!-!!!!!!-!!!!", 15, 8 )
        case object_selected = 18
          event_list_box( arr[], &LIST_SUNKEN, 10, selected_list, headof_list, 15, 51, 21, 76, 0, 7, 3, .f. )
          if lastkey() = 0 .or. lastkey() = 1 .or. lastkey() = 2 .or. lastkey() = 13
            if selected_list >=0 .and. selected_list <= 4
              gui_wallpaper( xarr[ selected_list ], -1, .f. )
              really_exit = .f.
              exit
            endif
          endif
      endcase
    enddo
    *\ Kill the objects since this will rebuild them
    object_destroy( 1 )
    if really_exit
      if gui_validate( "Are you sure you wish to exit the;" +;
                       "Special Forces GUI demonstration?;",;
                       -1, -1, 0, 15, "Exit Query", 15, 1,;
                       .t., .t., &BMP_QUESTION, 3 ) = &VALID_OK
        exit
      endif
    endif
  enddo
  gui_menu_clear( l_sub1 )
  gui_menu_clear( l_sub2 )
  gui_menu_clear( l_sub3 )
  gui_close()
endpro
