/*
  scan.c

  The file is part of the MIT Artificial Intelligence Laboratory's
  automatic fax transmission system.

  (c) Copyright 1990 by David M. Siegel
      All Rights Reserved.

  Sun Nov 4, 1990 at 11:16:34

  * Fri May 10, 1991 -- HQM
  When receive_mode is enabled, the scan loop now does a regular read on the
  serial port waiting for the MODEM_RING char '2', and sets the alarm to bail out
  after waiting QUEUE_INTERVAL. This is more polling the modem, I believe.


*/

#include <stdio.h>
#include <strings.h>
#include <dirent.h>
#include <sys/time.h>
#include <setjmp.h>
#include <signal.h>

#include "defines.h"
extern int serial_fd;

static int sigALRM();
static jmp_buf timeoutbuf;

static int
sigALRM()
{
	longjmp(timeoutbuf, 1);
}

#define MODEM_RING 	'2'

extern int debug;
extern int receive_mode;

extern void send_process();


/* wait around looking for RING signal from modem, or
 * for queue files to appear in the SPOOLDIR.
 * 
 */

void
scan_queue()
{
  DIR *dirp;
  struct dirent *dp;
  char *ptr;
  int ring;
  void (*f)();

  f = signal(SIGALRM, sigALRM);


  if (chdir(SPOOLDIR) < 0) {
    log("can't change to spool directory: %s\n", SPOOLDIR);
    return;
  }
  
  if ((dirp = opendir(".")) == NULL) {
    log("can't open fax spool directory: %s\n", SPOOLDIR);
    return;
  }
  
  for (dp = readdir(dirp); dp != NULL; dp = readdir(dirp)) {
    if ((ptr = rindex(dp->d_name, '.')) != NULL) {
      if (strcmp(ptr+1, "qf") == 0) {
	if (debug)
	  log("found queue file: %s\n", dp->d_name);
	*ptr = '\0';
	send_process(dp->d_name);
      }
    }
  }
  
  closedir(dirp);
  

  /* If fax reception is enabled, check the modem. */
  if (receive_mode) {
    alarm(QUEUE_INTERVAL); 
    if (setjmp(timeoutbuf) == 0) {
      if (wait_for_char(MODEM_RING, serial_fd)) {
	char filename[128];
	char incoming_seq_file[256];
	int seqnum;

	alarm(0);
	signal(SIGALRM, f);
	if (debug) printf("received RING signal\n");
      
	/* Generate a unique basefilename to store faxes into */
	sprintf(incoming_seq_file, "%s/%s", INCOMING, "FAXSEQ");
	seqnum = next_seq_number(incoming_seq_file);
	sprintf(filename, "fax%d", seqnum);

	faxreceive(filename, serial_fd);
      }
    } else {
      alarm(0);
      signal(SIGALRM, f);
    }
  }

}
