/*
  faxspooler.c

  The file is part of the MIT Artificial Intelligence Laboratory's
  Netfax automatic fax transmission system.

  This software is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
  to anyone for the consequences of using it or for whether it serves any
  particular purpose or works at all, unless he says so in writing.  Refer
  to the General Public License for full details.

  Everyone is granted permission to copy, modify and redistribute
  Netfax, but only under the conditions described in the Netfax
  General Public License.  A copy of this license is supposed to have been
  given to you along with Netfax so you can know your rights and
  responsibilities.  It should be in a file named COPYING.  Among other
  things, the copyright notice and this notice must be preserved on all
  copies.

  (c) Copyright 1990 by Henry Minsky and David M. Siegel.
      All rights reserved.

  Sun Nov 4, 1990 at 11:16:34

*/

#include <stdio.h>
#include <fcntl.h>
#include <sys/ioctl.h>

#include "defines.h"

int debug = FALSE;
/* default to receive incoming faxes i.e., answer the phone*/
int receive_mode = TRUE;

int use_syslog = FALSE;

static void
daemonize()
{
    int s;
    int pid;

    if ((pid = fork()) != 0) {
      if (pid < 0)
	  perror("start_daemon: fork");
      exit(0);
    }

    for (s = getdtablesize()-1; s >= 0; --s)
      close(s);

    open("/dev/null", O_RDONLY);
    dup2(0, 1);
    dup2(0, 2);
	
    /* disassociate server from controlling terminal */
    if ((s = open("/dev/tty", O_RDWR)) >= 0) {
	ioctl(s, TIOCNOTTY, 0);
	close(s);
    }
}

/* modem serial port file descriptor */
int serial_fd;

main(argc,argv)
int argc;
char *argv[];
{
    int c;
    int errflg = FALSE;
    extern char *optarg;
    extern int optind;

    int be_daemon = FALSE;

    while ((c = getopt(argc, argv, "dDSr")) != -1)
      switch (c) {
	case 'd':
	  debug = TRUE;
	  break;
	case 'D':
	  be_daemon = TRUE;
	  use_syslog = TRUE;
	  break;
	case 'S':
	  use_syslog = TRUE;
	  break;
	case 'r':
	  receive_mode = FALSE;
	  break;
	case '?':
	  errflg = TRUE;;
	  break;
      }

    if (errflg) {
	(void)fprintf(stderr, "usage: %s [-D daemonize] [-d debug] [-r disable receive]", argv[0]);
	exit(1);
    }

    if (be_daemon)
      daemonize();

    serial_fd = open(SERIAL_PORT, O_RDWR);
    if (serial_fd < 0)
      {perror("sendfax couldn't open serial line "); exit(1);}
    
    if (tty_raw_mode_out(serial_fd) < 0) {
      fprintf(stderr, "couldn't put device in raw mode\n");
      exit(1); 
    }
    
    /* Try to initialize the faxmodem to a known state */
    faxmodem_sync(serial_fd);



    for (;;) {
      /* scan queue now uses select() with timeout of QUEUE_INTERVAL
	 to check for incoming ring signals
	 */
      scan_queue();
    }
}
