/*
  faxmail.c

  The file is part of the MIT Artificial Intelligence Laboratory's
  Netfax automatic fax transmission system.

  This software is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
  to anyone for the consequences of using it or for whether it serves any
  particular purpose or works at all, unless he says so in writing.  Refer
  to the General Public License for full details.

  Everyone is granted permission to copy, modify and redistribute
  Netfax, but only under the conditions described in the Netfax
  General Public License.  A copy of this license is supposed to have been
  given to you along with Netfax so you can know your rights and
  responsibilities.  It should be in a file named COPYING.  Among other
  things, the copyright notice and this notice must be preserved on all
  copies.

  (c) Copyright 1990 by Henry Minsky and David M. Siegel.
      All rights reserved.

  Sun Nov 4, 1990 at 11:16:34
*/

#include <stdio.h>
#include <strings.h>
#include <pwd.h>
#include "../include/conf.h"


#define TRUE 1
#define FALSE 0

main(argc,argv)
int argc;
char *argv[];
{
    char buf[BUFSIZ];
    int in_header = TRUE;
    int got_from = FALSE;
    int got_font = FALSE;
    int got_faxphone = FALSE;
    int got_faxrecipient = FALSE;
    int got_faxreturn = FALSE;
    int got_returnpath = FALSE; /* internet address of sender */
    char from[BUFSIZ];
    char returnpath[BUFSIZ];
    char faxphone[BUFSIZ];
    char faxrecipient[BUFSIZ];
    char faxreturn[BUFSIZ];
    char font[BUFSIZ];
    char *filename;
    FILE *fp;
    char tmpfnam[BUFSIZ];
    char cmd[BUFSIZ];
    struct passwd *pwd;

    int c;
    int errflg = FALSE;
    extern char *optarg;
    extern int optind;

    strcpy(font, ENSCRIPT_FONT);

    umask(0);
    
    sprintf(tmpfnam, "%s/mail-XXXXXX", SPOOLDIR);

    while ((c = getopt(argc, argv, "")) != -1)
      switch (c) {
	case '?':
	  errflg = TRUE;;
	  break;
      }

    if (errflg) {
	(void)fprintf(stderr, "usage: %s", argv[0]);
	exit(1);
    }

    while (fgets(buf, sizeof(buf), stdin) != NULL) {

	if (in_header) {

	    /* did we get the end of the header */
	    if (strlen(buf) == 1) {
		if (!(got_faxphone && got_from)) {
		    fprintf(stderr, "header parse error\n");
		    exit(1);
		}
		in_header = FALSE;
		filename = (char *)mktemp(tmpfnam);
		sprintf(cmd, "%s %s -f%s -p%s.ps", ENSCRIPT,
			ENSCRIPT_OPTIONS, font, filename);
		if ((fp = popen(cmd, "w")) == NULL) {
		    perror("popen enscript");
		    exit(1);
		}
	    } else {
		char *ptr = index(buf, ':');

		if (ptr == NULL)
		  continue;

		*ptr = '\0';
		
		if (!got_faxphone) {
		    if (strcasecmp(buf, "faxphone") == 0) {
			strcpy(faxphone, ptr+2);
			faxphone[strlen(faxphone)-1] = '\0';
			got_faxphone = TRUE;
		    }
		}

		if (!got_faxrecipient) {
		    if (strcasecmp(buf, "faxrecipient") == 0) {
			strcpy(faxrecipient, ptr+2);
			faxrecipient[strlen(faxrecipient)-1] = '\0';
			got_faxrecipient = TRUE;
		    }
		}


		/* Get the font if any... */
		if (!got_font) {
		    if (strcasecmp(buf, "faxfont") == 0) {
			strcpy(font, ptr+2);
			font[strlen(font)-1] = '\0';
			got_font = TRUE;
		    }
		}

		/* Get the returnpath... 
		   example "Return-Path: <hqm@media-lab.media.mit.edu>"
		   */

		if (strcasecmp(buf, "Return-Path") == 0) {
		  char *leftbrace;

		  leftbrace = index(ptr+1, '<');
		  if (leftbrace != NULL) {

		    strcpy(returnpath, leftbrace+1);
		    /* get rid of a newline at the end */
		    returnpath[strlen(returnpath)-1] = '\0';

		    leftbrace = index(returnpath, '>');
		    if (leftbrace != NULL) *leftbrace = '\0';

		    got_returnpath = TRUE;
		  }
		}

		/* The "fax reply to" field for the coversheet */
		if (!got_faxreturn) {
		    if (strcasecmp(buf, "faxreturn") == 0) {
			strcpy(faxreturn, ptr+2);
			faxreturn[strlen(faxreturn)-1] = '\0';
			got_faxreturn = TRUE;
		    
		    }
		}

		if (!got_from) {
		    if (strcasecmp(buf, "from") == 0) {
			char *at;
			strcpy(from, ptr+2);
			from[strlen(from)-1] = '\0';
			got_from = TRUE;
		      }
		  }
	    }
	} else
	  fputs(buf, fp);
    }

    pclose(fp);

    /*
      Write out queue file:
    */
/*
    security? nah.

    if ((pwd = getpwnam(from)) == NULL) {
	fprintf(stderr, "can't figure out who you are!\n");
	exit(1);
    }
*/
    sprintf(cmd, "%s.qf", filename);
    if ((fp = fopen(cmd, "w")) == NULL) {
	fprintf(stderr, "can't open queue file\n");
	exit(1);
    }

    /* If there is a return email path, put it in the USER: field,
       so that the faxspooler can send an email confirmation of transmit
       status. Else put in the from field, which may be trash, and 
       tell the spooler not to send email confirmation
       */
    if (got_returnpath) 
      fprintf(fp, "USER: %s\n", returnpath);
    else {
      fprintf(fp, "USER: %s\n", from);
      fprintf(fp, "NOMAIL: 1\n");
    }

    fprintf(fp, "SENDER: %s\n", from);
      
    if (got_faxrecipient)
      fprintf(fp, "RECIPIENT: %s\n", faxrecipient);
    if (got_faxreturn)
      fprintf(fp, "RETURNFAX: %s\n", faxreturn);
    fprintf(fp, "PHONE: %s\n", faxphone);
/*     fprintf(fp, "NOCOVER: 1\n");  */
    fclose(fp);

    exit(0);
}
