;; Spool Emacs buffer on to Fax Modem.
;; Copyright (C) 1985, 1988 Free Software Foundation, Inc.

;; This file is part of GNU Emacs.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY.  No author or distributor
;; accepts responsibility to anyone for the consequences of using it
;; or for whether it serves any particular purpose or works at all,
;; unless he says so in writing.  Refer to the GNU Emacs General Public
;; License for full details.

;; Everyone is granted permission to copy, modify and redistribute
;; GNU Emacs, but only under the conditions described in the
;; GNU Emacs General Public License.   A copy of this license is
;; supposed to have been given to you along with GNU Emacs so you
;; can know your rights and responsibilities.  It should be in a
;; file named COPYING.  Among other things, the copyright notice
;; and this notice must be preserved on all copies.

;; Created by Henry Minsky
;; for use with the  netfax fax spooling software package
;;  
;; Note that the call to the fax program has the "-c" flag set
;; meaning that the cover sheet will be omitted. Save a tree.

(defvar fax-command "/usr/local/bin/fax"
  "Shell command for faxing a file")

(defvar last-fax-recipient ""
  "Default recipient name to appear on fax coversheet")

(defvar last-dialstring ""
  "Default fax number to dial")

(defun get-fax-args ()
  (setq last-fax-recipient
	(read-from-minibuffer
	 "Recipient name: " last-fax-recipient))
  (setq last-dialstring
	(read-from-minibuffer
	 "Phone number to dial: " last-dialstring))
  (list last-dialstring last-fax-recipient))


(defun fax-buffer (dialstring recipient)
  "Print buffer contents as with Unix command `fax'."
  (interactive (get-fax-args))
  (fax-region-1 (point-min) (point-max) dialstring recipient))

(defun fax-region (start end dialstring recipient)
  "Fax region contents as with Unix command `fax -r <recipient>' <phonenum>."
  (interactive (get-fax-args))
  (fax-region-1 start end dialstring recipient))

(defun fax-region-1 (start end dialstring recipient)
  (let ((name (concat (buffer-name) " Emacs buffer"))
	(width tab-width))
    (save-excursion
      (message "Spooling...")
      (if (/= tab-width 8)
	  (let ((oldbuf (current-buffer)))
	    (set-buffer (get-buffer-create " *spool temp*"))
	    (widen) (erase-buffer)
	    (insert-buffer-substring oldbuf start end)
	    (setq tab-width width)
	    (untabify (point-min) (point-max))
	    (setq start (point-min) end (point-max))))
      (call-process-region 
         start end fax-command
	 nil nil nil (concat "-r " recipient) dialstring)
    (message "Spooling...done"))))
