/*
  The spool directory for the fax spooler.  Normally, this would be
  /com/fax:
*/
#define SPOOLDIR 	"/com/fax/outgoing"

/* The incoming fax directory */
#define INCOMING	"/com/fax/incoming"

/*
  The lib directory for the fax spooler.  Normally, this would be
  /usr/local/lib/fax:
*/
#define LIBDIR		"/usr/local/lib/fax"

/*
  The fax long distance account access file.  Normally, this would be
  in /etc/faxusers:
*/
#define USERFILE	"/etc/faxusers"

/*
  How often should the daemon check the spool directory for new fax
  jobs, in seconds?
*/
#define QUEUE_INTERVAL	15

/*
  How long should the daemon wait to retry sending a fax job, in
  seconds?
*/
#define RETRY_INTERVAL	300

/*
  How many times should the daemon attempt to send one job?
*/
#define MAX_RETRIES	5

/* 
  Default lab return fax number for coversheet:
*/
#define DEFAULT_RETURNFAX "(617) 253-5060"

/* 
  The serial port on the spooler host which the modem is connected to:
*/
#define SERIAL_PORT "/dev/ttyi4"

/* 
  The program to use to convert plain ASCII to postscript:
*/
#define USE_ENSCRIPT 	TRUE
#define USE_PSIFY       FALSE

#define GSPATH          "/usr/local/bin/gs"


/* Options and executable pathnames for fax/fax.c client */

/* If you are using psify to convert text to postscript, here is 
   where the executable lives */
#define PSIFY    "/usr/local/bin/psify"

/* If you are using enscript ... */
#define ENSCRIPT "/usr/local/bin/enscript"
#define ENSCRIPT_OPTIONS "-G"
#define ENSCRIPT_FONT "Courier-Bold12"

/* TeX DVI to postscript converter. if you got one */
#define DVI2PS	 "/usr/local/bin/dvi2ps"
#define DVIFONT	 "/usr/local/lib/tex/pxlfonts.xerox"
