/* 
 * 
 * Utility to supply a unique sequence number for a filename.
 *
 * Uses a file in the current directory ,"SEQUENCE" for example, to hold
 * a counter.
 *
 * call next_seq_number() to return the current seq
 * number, and increment the counter. If the sequence file does
 * not exist, it is created
 *
 *
 * Henry Minsky 
 * hqm@ai.mit.edu
 * 
 *
 */

#include <stdio.h>
#include <sys/file.h>
#include <unistd.h>

/* Assume we have chdir'd to the right directory */
int next_seq_number(filename)
     char *filename;
{	
  FILE *seqfile;
  int newseq = 0;

  if ((seqfile = fopen(filename, "r+")) == NULL)
    {
      /* can't access, so try to create new one */
      if (seqfile = fopen(filename, "w+"))
	{ fprintf(seqfile, "0\n"); /* initialize to zero */
	  rewind(seqfile);
	}
      else  /* can't create file, we're fucked */
	return(0);
    }
  
  /* seqfile should now point to a file, opened for read/write */
  if (fscanf(seqfile, "%d", &newseq) != 1) newseq  = 0;
  
  fclose(seqfile);

  unlink(filename); /* delete the old seq file */
  
  if (seqfile = fopen(filename, "w+"))
    { fprintf(seqfile, "%d\n", newseq + 1);
      fclose(seqfile);
    }
  return(newseq);
}
  
